/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.repository;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.repository.DefaultExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.ExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.repository.internal.installed.AbstractInstalledExtensionRepository;
import org.xwiki.extension.xar.internal.handler.UnsupportedNamespaceException;
import org.xwiki.extension.xar.internal.handler.XarHandlerUtils;
import org.xwiki.extension.xar.internal.repository.XarInstalledExtension;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.xar.XarEntry;
import org.xwiki.xar.XarException;

@Component
@Singleton
@Named(value="xar")
public class XarInstalledExtensionRepository
extends AbstractInstalledExtensionRepository<XarInstalledExtension>
implements InstalledExtensionRepository,
Initializable {
    @Inject
    private transient InstalledExtensionRepository installedRepository;
    @Inject
    private Logger logger;
    private Map<DocumentReference, Collection<XarInstalledExtension>> documents = new ConcurrentHashMap<DocumentReference, Collection<XarInstalledExtension>>();
    private Map<LocalDocumentReference, Collection<XarInstalledExtension>> rootDocuments = new ConcurrentHashMap<LocalDocumentReference, Collection<XarInstalledExtension>>();

    public void initialize() throws InitializationException {
        this.setDescriptor((ExtensionRepositoryDescriptor)new DefaultExtensionRepositoryDescriptor("xar", "xar", this.installedRepository.getDescriptor().getURI()));
        this.loadExtensions();
    }

    void pagesRemoved(ExtensionId extensionId, String namespace) throws UnsupportedNamespaceException {
        this.pagesUpdated(extensionId, namespace, false);
    }

    void pagesAdded(ExtensionId extensionId, String namespace) throws UnsupportedNamespaceException {
        this.pagesUpdated(extensionId, namespace, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pagesUpdated(ExtensionId extensionId, String namespace, boolean add) throws UnsupportedNamespaceException {
        XarInstalledExtension installedExtension = (XarInstalledExtension)this.getInstalledExtension(extensionId);
        if (installedExtension != null) {
            for (XarEntry xarEntry : installedExtension.getXarPackage().getEntries()) {
                if (namespace != null) {
                    DocumentReference reference = new DocumentReference((LocalDocumentReference)xarEntry, new WikiReference(XarHandlerUtils.getWikiFromNamespace(namespace)));
                    Map<DocumentReference, Collection<XarInstalledExtension>> map = this.documents;
                    synchronized (map) {
                        Collection<XarInstalledExtension> referenceExtensions = this.documents.get(reference);
                        if (referenceExtensions != null || add) {
                            LinkedHashSet<XarInstalledExtension> newSet;
                            LinkedHashSet<XarInstalledExtension> linkedHashSet = newSet = referenceExtensions != null ? new LinkedHashSet<XarInstalledExtension>(referenceExtensions) : new LinkedHashSet();
                            if (add) {
                                newSet.add(installedExtension);
                            } else {
                                newSet.remove((Object)installedExtension);
                            }
                            this.documents.put(reference, newSet);
                        }
                        continue;
                    }
                }
                Map<LocalDocumentReference, Collection<XarInstalledExtension>> map = this.rootDocuments;
                synchronized (map) {
                    Collection<XarInstalledExtension> referenceExtensions = this.rootDocuments.get(xarEntry);
                    if (referenceExtensions != null || add) {
                        LinkedHashSet<XarInstalledExtension> newSet;
                        LinkedHashSet<XarInstalledExtension> linkedHashSet = newSet = referenceExtensions != null ? new LinkedHashSet<XarInstalledExtension>(referenceExtensions) : new LinkedHashSet();
                        if (add) {
                            newSet.add(installedExtension);
                        } else {
                            newSet.remove((Object)installedExtension);
                        }
                        this.rootDocuments.put((LocalDocumentReference)xarEntry, newSet);
                    }
                }
            }
        }
    }

    void updateCachedXarExtension(ExtensionId extensionId) {
        InstalledExtension installedExtension = this.installedRepository.getInstalledExtension(extensionId);
        if (installedExtension != null && installedExtension.getType().equals("xar")) {
            if (this.getInstalledExtension(installedExtension.getId()) == null) {
                try {
                    this.addCacheXarExtension(installedExtension);
                }
                catch (Exception e) {
                    this.logger.error("Failed to parse extension [{}]", (Object)installedExtension.getId(), (Object)e);
                }
            }
        } else {
            this.removeCachedXarExtension(extensionId);
        }
    }

    private void addCacheXarExtension(InstalledExtension installedExtension) throws IOException, XarException {
        XarInstalledExtension xarExtension = new XarInstalledExtension(installedExtension, this);
        this.addCachedExtension((Extension)xarExtension);
    }

    protected void removeCachedXarExtension(ExtensionId extensionId) {
        XarInstalledExtension extension = (XarInstalledExtension)this.getInstalledExtension(extensionId);
        if (extension != null) {
            super.removeCachedExtension((Extension)extension);
        }
    }

    private void loadExtensions() {
        for (InstalledExtension localExtension : this.installedRepository.getInstalledExtensions()) {
            if (!localExtension.getType().equalsIgnoreCase("xar")) continue;
            try {
                this.addCacheXarExtension(localExtension);
            }
            catch (Exception e) {
                this.logger.error("Failed to parse extension [{}]", (Object)localExtension.getId(), (Object)e);
            }
        }
    }

    public Collection<XarInstalledExtension> getXarInstalledExtensions(DocumentReference reference) {
        Collection<XarInstalledExtension> wikiExtensions = this.documents.get(reference);
        Collection<XarInstalledExtension> rootExtensions = this.rootDocuments.get(reference);
        ArrayList<XarInstalledExtension> allExtensions = new ArrayList<XarInstalledExtension>();
        if (wikiExtensions != null) {
            allExtensions.addAll(wikiExtensions);
        }
        if (rootExtensions != null) {
            allExtensions.addAll(rootExtensions);
        }
        return allExtensions;
    }

    public InstalledExtension getInstalledExtension(String id, String namespace) {
        Object extension = this.installedRepository.getInstalledExtension(id, namespace);
        if (extension != null) {
            extension = extension.getType().equals("xar") ? (InstalledExtension)this.extensions.get(extension.getId()) : null;
        }
        return extension;
    }

    public InstalledExtension installExtension(LocalExtension extension, String namespace, boolean dependency, Map<String, Object> properties) throws InstallException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void uninstallExtension(InstalledExtension extension, String namespace) throws UninstallException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Collection<InstalledExtension> getBackwardDependencies(String id, String namespace) throws ResolveException {
        InstalledExtension extension = this.installedRepository.getInstalledExtension(id, namespace);
        return extension.getType().equals("xar") ? this.installedRepository.getBackwardDependencies(id, namespace) : null;
    }

    public Map<String, Collection<InstalledExtension>> getBackwardDependencies(ExtensionId extensionId) throws ResolveException {
        InstalledExtension extension = this.installedRepository.resolve(extensionId);
        return extension.getType().equals("xar") ? this.installedRepository.getBackwardDependencies(extensionId) : null;
    }
}

