/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.script.internal.safe;

import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.xwiki.context.Execution;
import org.xwiki.script.internal.safe.AbstractSafeObject;
import org.xwiki.script.internal.safe.ScriptSafeProvider;

public abstract class AbstractNoExceptionSafeObject<T>
extends AbstractSafeObject<T> {
    protected boolean hasProgrammingRight;
    @Inject
    private Execution execution;

    public AbstractNoExceptionSafeObject(T wrapped, ScriptSafeProvider<?> safeProvider, Execution execution) {
        this(wrapped, safeProvider, execution, false);
    }

    public AbstractNoExceptionSafeObject(T wrapped, ScriptSafeProvider<?> safeProvider, Execution execution, boolean hasProgrammingRight) {
        super(wrapped, safeProvider);
        this.execution = execution;
        this.hasProgrammingRight = hasProgrammingRight;
    }

    public Exception getLastError() {
        return (Exception)this.execution.getContext().getProperty("scriptservice.extension.error");
    }

    protected void setError(Exception e) {
        this.execution.getContext().setProperty("scriptservice.extension.error", (Object)e);
    }

    protected <R> R wrapError(Callable<R> callable) {
        this.setError(null);
        try {
            return callable.call();
        }
        catch (Exception e) {
            this.setError(e);
            return null;
        }
    }

    protected <R> R safeWrapError(Callable<R> callable) {
        return (R)this.wrapError(() -> this.safe(callable.call()));
    }
}

