/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.script.internal.safe;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.xwiki.component.namespace.Namespace;
import org.xwiki.context.Execution;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.repository.result.IterableResult;
import org.xwiki.extension.repository.search.ExtensionQuery;
import org.xwiki.extension.repository.search.SearchException;
import org.xwiki.extension.script.internal.safe.SafeAdvancedSearchableExtensionRepository;
import org.xwiki.extension.tree.ExtensionNode;
import org.xwiki.script.internal.safe.ScriptSafeProvider;

public class SafeInstalledExtensionRepository<T extends InstalledExtensionRepository>
extends SafeAdvancedSearchableExtensionRepository<T>
implements InstalledExtensionRepository {
    public SafeInstalledExtensionRepository(T repository, ScriptSafeProvider<?> safeProvider, Execution execution, boolean hasProgrammingRight) {
        super(repository, safeProvider, execution, hasProgrammingRight);
    }

    public int countExtensions() {
        return ((InstalledExtensionRepository)this.getWrapped()).countExtensions();
    }

    public InstalledExtension getInstalledExtension(ExtensionId extensionId) {
        return (InstalledExtension)this.safe(((InstalledExtensionRepository)this.getWrapped()).getInstalledExtension(extensionId));
    }

    public InstalledExtension getInstalledExtension(String feature, String namespace) {
        return (InstalledExtension)this.safe(((InstalledExtensionRepository)this.getWrapped()).getInstalledExtension(feature, namespace));
    }

    public InstalledExtension installExtension(LocalExtension extension, String namespace, boolean dependency) {
        return this.installExtension(extension, namespace, dependency, Collections.emptyMap());
    }

    public InstalledExtension installExtension(LocalExtension extension, String namespace, boolean dependency, Map<String, Object> properties) {
        if (!this.hasProgrammingRight) {
            this.setError(new UnsupportedOperationException("Operation forbidden in script proxy"));
            return null;
        }
        this.setError(null);
        try {
            return (InstalledExtension)this.safe(((InstalledExtensionRepository)this.getWrapped()).installExtension(extension, namespace, dependency, properties));
        }
        catch (InstallException e) {
            this.setError((Exception)((Object)e));
            return null;
        }
    }

    public void uninstallExtension(InstalledExtension extension, String namespace) {
        if (!this.hasProgrammingRight) {
            this.setError(new UnsupportedOperationException("Operation forbidden in script proxy"));
            return;
        }
        this.setError(null);
        try {
            ((InstalledExtensionRepository)this.getWrapped()).uninstallExtension(extension, namespace);
        }
        catch (UninstallException e) {
            this.setError((Exception)((Object)e));
        }
    }

    public Collection<InstalledExtension> getBackwardDependencies(String feature, String namespace) {
        return this.safeWrapError(() -> ((InstalledExtensionRepository)this.getWrapped()).getBackwardDependencies(feature, namespace));
    }

    public Collection<InstalledExtension> getBackwardDependencies(String feature, String namespace, boolean withOptionals) throws ResolveException {
        return this.safeWrapError(() -> ((InstalledExtensionRepository)this.getWrapped()).getBackwardDependencies(feature, namespace, withOptionals));
    }

    public Map<String, Collection<InstalledExtension>> getBackwardDependencies(ExtensionId extensionId) {
        return this.safeWrapError(() -> ((InstalledExtensionRepository)this.getWrapped()).getBackwardDependencies(extensionId));
    }

    public Map<String, Collection<InstalledExtension>> getBackwardDependencies(ExtensionId extensionId, boolean withOptionals) throws ResolveException {
        return this.safeWrapError(() -> ((InstalledExtensionRepository)this.getWrapped()).getBackwardDependencies(extensionId, withOptionals));
    }

    public Collection<InstalledExtension> getInstalledExtensions() {
        return (Collection)this.safe(((InstalledExtensionRepository)this.getWrapped()).getInstalledExtensions());
    }

    public Collection<InstalledExtension> getInstalledExtensions(String namespace) {
        return (Collection)this.safe(((InstalledExtensionRepository)this.getWrapped()).getInstalledExtensions(namespace));
    }

    public InstalledExtension resolve(ExtensionDependency extensionDependency) {
        return (InstalledExtension)super.resolve(extensionDependency);
    }

    public InstalledExtension resolve(ExtensionId extensionId) {
        return (InstalledExtension)super.resolve(extensionId);
    }

    public IterableResult<InstalledExtension> searchInstalledExtensions(String pattern, String namespace, int offset, int nb) throws SearchException {
        return (IterableResult)this.safe(((InstalledExtensionRepository)this.getWrapped()).searchInstalledExtensions(pattern, namespace, offset, nb));
    }

    public IterableResult<InstalledExtension> searchInstalledExtensions(String namespace, ExtensionQuery query) throws SearchException {
        return (IterableResult)this.safe(((InstalledExtensionRepository)this.getWrapped()).searchInstalledExtensions(namespace, query));
    }

    public IterableResult<InstalledExtension> searchInstalledExtensions(ExtensionQuery query) throws SearchException {
        return (IterableResult)this.safe(((InstalledExtensionRepository)this.getWrapped()).searchInstalledExtensions(query));
    }

    public IterableResult<InstalledExtension> searchInstalledExtensions(Collection<String> namespaces, ExtensionQuery query) throws SearchException {
        return (IterableResult)this.safe(((InstalledExtensionRepository)this.getWrapped()).searchInstalledExtensions(namespaces, query));
    }

    public ExtensionNode<InstalledExtension> getOrphanedDependencies(InstalledExtension extension, Namespace namespace) {
        return (ExtensionNode)this.safe(((InstalledExtensionRepository)this.getWrapped()).getOrphanedDependencies(extension, namespace));
    }
}

