/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.feed;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndImage;
import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.plugin.PluginApi;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.feed.FeedPlugin;
import com.xpn.xwiki.plugin.feed.SyndEntryDocumentSource;
import com.xpn.xwiki.plugin.feed.SyndEntrySource;
import com.xpn.xwiki.plugin.feed.SyndEntrySourceApi;
import com.xpn.xwiki.plugin.feed.UpdateThread;
import com.xpn.xwiki.web.XWikiRequest;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FeedPluginApi
extends PluginApi<FeedPlugin> {
    private static final String BLOG_POST_CLASS_NAME = "Blog.BlogPostClass";
    private static final String BLOG_POST_TEMPLATE_NAME = "Blog.BlogPostTemplate";
    private static final Map<String, Object> BLOG_FIELDS_MAPPING = new HashMap<String, Object>();
    public static final String FEED_PLUGIN_EXCEPTION = "FeedPluginException";

    public FeedPluginApi(FeedPlugin plugin, XWikiContext context) {
        super((XWikiPluginInterface)plugin, context);
    }

    @Deprecated
    public FeedPlugin getPlugin() {
        return (FeedPlugin)super.getInternalPlugin();
    }

    public SyndFeed getFeeds(String sfeeds) throws IOException {
        return ((FeedPlugin)this.getProtectedPlugin()).getFeeds(sfeeds, this.getXWikiContext());
    }

    public SyndFeed getFeeds(String sfeeds, boolean force) throws IOException {
        return ((FeedPlugin)this.getProtectedPlugin()).getFeeds(sfeeds, force, this.getXWikiContext());
    }

    public SyndFeed getFeeds(String sfeeds, boolean ignoreInvalidFeeds, boolean force) throws IOException {
        return ((FeedPlugin)this.getProtectedPlugin()).getFeeds(sfeeds, ignoreInvalidFeeds, force, this.getXWikiContext());
    }

    public SyndFeed getFeed(String sfeed) throws IOException {
        return ((FeedPlugin)this.getProtectedPlugin()).getFeed(sfeed, false, this.getXWikiContext());
    }

    public SyndFeed getFeed(String sfeed, boolean force) throws IOException {
        return ((FeedPlugin)this.getProtectedPlugin()).getFeed(sfeed, force, this.getXWikiContext());
    }

    public SyndFeed getFeed(String sfeed, boolean ignoreInvalidFeeds, boolean force) throws IOException {
        return ((FeedPlugin)this.getProtectedPlugin()).getFeed(sfeed, ignoreInvalidFeeds, force, this.getXWikiContext());
    }

    public int updateFeeds() throws XWikiException {
        return this.updateFeeds("XWiki.FeedList");
    }

    public int updateFeeds(String feedDoc) throws XWikiException {
        return this.updateFeeds(feedDoc, true);
    }

    public int updateFeeds(String feedDoc, boolean fullContent) throws XWikiException {
        return this.updateFeeds(feedDoc, fullContent, true);
    }

    public int updateFeeds(String feedDoc, boolean fullContent, boolean oneDocPerEntry) throws XWikiException {
        if (this.hasProgrammingRights()) {
            return ((FeedPlugin)this.getProtectedPlugin()).updateFeeds(feedDoc, fullContent, oneDocPerEntry, this.getXWikiContext());
        }
        return -1;
    }

    public int updateFeeds(String feedDoc, boolean fullContent, boolean oneDocPerEntry, boolean force) throws XWikiException {
        if (this.hasProgrammingRights()) {
            return ((FeedPlugin)this.getProtectedPlugin()).updateFeeds(feedDoc, fullContent, oneDocPerEntry, force, this.getXWikiContext());
        }
        return -1;
    }

    public int updateFeeds(String feedDoc, boolean fullContent, boolean oneDocPerEntry, boolean force, String space) throws XWikiException {
        if (this.hasProgrammingRights()) {
            return ((FeedPlugin)this.getProtectedPlugin()).updateFeeds(feedDoc, fullContent, oneDocPerEntry, force, space, this.getXWikiContext());
        }
        return -1;
    }

    public int updateFeedsInSpace(String space, boolean fullContent, boolean force) throws XWikiException {
        if (this.hasProgrammingRights()) {
            return ((FeedPlugin)this.getProtectedPlugin()).updateFeedsInSpace(space, fullContent, true, force, this.getXWikiContext());
        }
        return -1;
    }

    public int updateFeed(String feedname, String feedurl) {
        if (this.hasProgrammingRights()) {
            return ((FeedPlugin)this.getProtectedPlugin()).updateFeed(feedname, feedurl, false, true, this.getXWikiContext());
        }
        return -1;
    }

    public int updateFeed(String feedname, String feedurl, boolean fullContent) {
        if (this.hasProgrammingRights()) {
            return ((FeedPlugin)this.getProtectedPlugin()).updateFeed(feedname, feedurl, fullContent, true, this.getXWikiContext());
        }
        return -1;
    }

    public int updateFeed(String feedname, String feedurl, boolean fullContent, boolean oneDocPerEntry) {
        if (this.hasProgrammingRights()) {
            return ((FeedPlugin)this.getProtectedPlugin()).updateFeed(feedname, feedurl, fullContent, oneDocPerEntry, this.getXWikiContext());
        }
        return -1;
    }

    public int updateFeed(String feedname, String feedurl, boolean fullContent, boolean oneDocPerEntry, boolean force) {
        if (this.hasProgrammingRights()) {
            return ((FeedPlugin)this.getProtectedPlugin()).updateFeed(feedname, feedurl, fullContent, oneDocPerEntry, force, this.getXWikiContext());
        }
        return -1;
    }

    public int updateFeed(String feedname, String feedurl, boolean fullContent, boolean oneDocPerEntry, boolean force, String space) {
        if (this.hasProgrammingRights()) {
            return ((FeedPlugin)this.getProtectedPlugin()).updateFeed(feedname, feedurl, fullContent, oneDocPerEntry, force, space, this.getXWikiContext());
        }
        return -1;
    }

    public boolean startUpdateFeedsInSpace(String space, int scheduleTimer) throws XWikiException {
        return ((FeedPlugin)this.getProtectedPlugin()).startUpdateFeedsInSpace(space, false, scheduleTimer, this.context);
    }

    public boolean startUpdateFeedsInSpace(String space, boolean fullContent, int scheduleTimer) throws XWikiException {
        return ((FeedPlugin)this.getProtectedPlugin()).startUpdateFeedsInSpace(space, fullContent, scheduleTimer, this.context);
    }

    public void stopUpdateFeedsInSpace(String space) throws XWikiException {
        ((FeedPlugin)this.getProtectedPlugin()).stopUpdateFeedsInSpace(space, this.context);
    }

    public UpdateThread getUpdateThread(String space) {
        return ((FeedPlugin)this.getProtectedPlugin()).getUpdateThread(space, this.context);
    }

    public Collection<String> getActiveUpdateThreads() {
        return ((FeedPlugin)this.getProtectedPlugin()).getActiveUpdateThreads();
    }

    public SyndEntrySourceApi getSyndEntrySource(String className, Map<String, Object> params) {
        this.getXWikiContext().remove((Object)FEED_PLUGIN_EXCEPTION);
        try {
            SyndEntrySource source = ((FeedPlugin)this.getProtectedPlugin()).getSyndEntrySource(className, params, this.getXWikiContext());
            return new SyndEntrySourceApi(source, this.getXWikiContext());
        }
        catch (XWikiException e) {
            this.getXWikiContext().put((Object)FEED_PLUGIN_EXCEPTION, (Object)e);
            return null;
        }
    }

    public SyndEntrySourceApi getSyndEntrySource(String className) {
        return this.getSyndEntrySource(className, null);
    }

    public SyndEntrySourceApi getSyndEntryDocumentSource(Map<String, Object> params) {
        return this.getSyndEntrySource(SyndEntryDocumentSource.class.getName());
    }

    public SyndEntrySourceApi getSyndEntryDocumentSource() {
        Map<String, Object> params = Collections.emptyMap();
        return this.getSyndEntryDocumentSource(params);
    }

    public SyndEntrySourceApi getSyndEntryArticleSource() {
        Map<String, Object> params = Collections.emptyMap();
        return this.getSyndEntryArticleSource(params);
    }

    public SyndEntrySourceApi getSyndEntryArticleSource(Map<String, Object> params) {
        HashMap<String, Object> defParams = new HashMap<String, Object>();
        defParams.put("title", "XWiki.ArticleClass_title");
        defParams.put("description", "XWiki.ArticleClass_content");
        defParams.put("categories", "XWiki.ArticleClass_category");
        defParams.put("ContentLength", new Integer(400));
        defParams.putAll(params);
        return this.getSyndEntrySource(SyndEntryDocumentSource.class.getName(), defParams);
    }

    public SyndEntry getFeedEntry() {
        return ((FeedPlugin)this.getProtectedPlugin()).getFeedEntry(this.getXWikiContext());
    }

    public SyndImage getFeedImage() {
        return ((FeedPlugin)this.getProtectedPlugin()).getFeedImage(this.context);
    }

    public SyndImage getFeedImage(String url, String link, String title, String description) {
        SyndImage image = this.getFeedImage();
        image.setUrl(url);
        image.setLink(link);
        image.setTitle(title);
        image.setDescription(description);
        return image;
    }

    public SyndImage getDefaultFeedImage() {
        XWiki xwiki = this.getXWikiContext().getWiki();
        String fileName = xwiki.getSkinPreference("logo", "logo.png", this.getXWikiContext());
        String url = xwiki.getSkinFile(fileName, this.getXWikiContext());
        String port = "";
        XWikiRequest request = this.getXWikiContext().getRequest();
        if ("http".equals(request.getScheme()) && request.getServerPort() != 80 || "https".equals(request.getScheme()) && request.getServerPort() != 443) {
            port = ":" + request.getServerPort();
        }
        url = request.getScheme() + "://" + request.getServerName() + port + url;
        String link = "http://" + request.getServerName();
        return this.getFeedImage(url, link, "XWiki Logo", "XWiki Logo");
    }

    public SyndFeed getFeed() {
        return ((FeedPlugin)this.getProtectedPlugin()).getFeed(this.getXWikiContext());
    }

    public SyndFeed getFeed(List<Object> list, SyndEntrySourceApi sourceApi, Map<String, Object> sourceParams) {
        Map<String, Object> metadata = Collections.emptyMap();
        return this.getFeed(list, sourceApi, sourceParams, metadata);
    }

    public SyndFeed getDocumentFeed(List<Object> list, Map<String, Object> params) {
        Map<String, Object> metadata = Collections.emptyMap();
        return this.getDocumentFeed(list, params, metadata);
    }

    public SyndFeed getArticleFeed(List<Object> list) {
        Map<String, Object> params = Collections.emptyMap();
        return this.getArticleFeed(list, params);
    }

    public SyndFeed getWebFeed(List<Object> list) {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        return this.getWebFeed(list, metadata);
    }

    public SyndFeed getBlogFeed(List<Object> list) {
        Map<String, Object> params = Collections.emptyMap();
        return this.getBlogFeed(list, params);
    }

    public SyndFeed getFeed(String query, int count, int start, SyndEntrySourceApi sourceApi, Map<String, Object> sourceParams) {
        Map<String, Object> metadata = Collections.emptyMap();
        return this.getFeed(query, count, start, sourceApi, sourceParams, metadata);
    }

    public SyndFeed getDocumentFeed(String query, int count, int start, Map<String, Object> params) {
        Map<String, Object> metadata = Collections.emptyMap();
        return this.getDocumentFeed(query, count, start, params, metadata);
    }

    public SyndFeed getArticleFeed(String query, int count, int start) {
        Map<String, Object> params = Collections.emptyMap();
        return this.getArticleFeed(query, count, start, params);
    }

    public SyndFeed getWebFeed(String query, int count, int start) {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        return this.getWebFeed(query, count, start, metadata);
    }

    public SyndFeed getBlogFeed(String query, int count, int start) {
        return this.getBlogFeed(query, count, start, Collections.<String, Object>emptyMap());
    }

    public SyndFeed getFeed(List<Object> list, SyndEntrySourceApi sourceApi, Map<String, Object> sourceParams, Map<String, Object> metadata) {
        this.getXWikiContext().remove((Object)FEED_PLUGIN_EXCEPTION);
        try {
            return ((FeedPlugin)this.getProtectedPlugin()).getFeed(list, sourceApi.getSyndEntrySource(), sourceParams, metadata, this.getXWikiContext());
        }
        catch (XWikiException e) {
            this.getXWikiContext().put((Object)FEED_PLUGIN_EXCEPTION, (Object)e);
            return null;
        }
    }

    public SyndFeed getDocumentFeed(List<Object> list, Map<String, Object> params, Map<String, Object> metadata) {
        return this.getFeed(list, this.getSyndEntryDocumentSource(), params, metadata);
    }

    public SyndFeed getArticleFeed(List<Object> list, Map<String, Object> metadata) {
        Map<String, Object> params = Collections.emptyMap();
        return this.getFeed(list, this.getSyndEntryArticleSource(), params, metadata);
    }

    private static boolean keyHasValue(Map<String, Object> map, String key, Object defaultValue) {
        Object value = map.get(key);
        return value != null && !value.equals(defaultValue);
    }

    private Map<String, Object> fillWebFeedMetadata(Map<String, Object> metadata) {
        String title;
        String description = title = "Feed for document changes";
        if (!FeedPluginApi.keyHasValue(metadata, "title", "")) {
            metadata.put("title", title);
        }
        if (!FeedPluginApi.keyHasValue(metadata, "description", "")) {
            metadata.put("description", description);
        }
        return metadata;
    }

    private Map<String, Object> fillBlogFeedMetadata(Map<String, Object> metadata) {
        String title;
        HashMap<String, Object> result = new HashMap<String, Object>(metadata);
        String description = title = "Personal Wiki Blog";
        if (!FeedPluginApi.keyHasValue(result, "title", "")) {
            result.put("title", title);
        }
        if (!FeedPluginApi.keyHasValue(result, "description", "")) {
            result.put("description", description);
        }
        return result;
    }

    public SyndFeed getWebFeed(List<Object> list, Map<String, Object> metadata) {
        Map<String, Object> params = Collections.emptyMap();
        SyndFeed webFeed = this.getDocumentFeed(list, params, this.fillWebFeedMetadata(metadata));
        if (webFeed != null) {
            webFeed.setImage(this.getDefaultFeedImage());
        }
        return webFeed;
    }

    public SyndFeed getBlogFeed(List<Object> list, Map<String, Object> metadata) {
        Map<String, Object> params = Collections.emptyMap();
        SyndFeed blogFeed = this.getFeed(list, this.getSyndEntrySource(SyndEntryDocumentSource.class.getName(), BLOG_FIELDS_MAPPING), params, this.fillBlogFeedMetadata(metadata));
        if (blogFeed != null) {
            blogFeed.setImage(this.getDefaultFeedImage());
        }
        return blogFeed;
    }

    public SyndFeed getFeed(String query, int count, int start, SyndEntrySourceApi sourceApi, Map<String, Object> sourceParams, Map<String, Object> metadata) {
        this.getXWikiContext().remove((Object)FEED_PLUGIN_EXCEPTION);
        try {
            return ((FeedPlugin)this.getProtectedPlugin()).getFeed(query, count, start, sourceApi.getSyndEntrySource(), sourceParams, metadata, this.getXWikiContext());
        }
        catch (XWikiException e) {
            this.getXWikiContext().put((Object)FEED_PLUGIN_EXCEPTION, (Object)e);
            return null;
        }
    }

    public SyndFeed getDocumentFeed(String query, int count, int start, Map<String, Object> params, Map<String, Object> metadata) {
        return this.getFeed(query, count, start, this.getSyndEntryDocumentSource(), params, metadata);
    }

    public SyndFeed getArticleFeed(String query, int count, int start, Map<String, Object> metadata) {
        Map<String, Object> params = Collections.emptyMap();
        return this.getFeed(query, count, start, this.getSyndEntryArticleSource(), params, metadata);
    }

    public SyndFeed getWebFeed(String query, int count, int start, Map<String, Object> metadata) {
        HashMap<String, Object> params;
        SyndFeed webFeed;
        if (query == null) {
            query = "where 1=1 order by doc.date desc";
        }
        if ((webFeed = this.getDocumentFeed(query, count, start, params = new HashMap<String, Object>(), this.fillWebFeedMetadata(metadata))) != null) {
            webFeed.setImage(this.getDefaultFeedImage());
        }
        return webFeed;
    }

    public SyndFeed getBlogFeed(String query, int count, int start, Map<String, Object> metadata) {
        return this.getBlogFeed(query, count, start, null, metadata);
    }

    public SyndFeed getBlogFeed(String query, int count, int start, String blogPostClassName, Map<String, Object> metadata) {
        if (query == null) {
            XWikiRequest request = this.getXWikiContext().getRequest();
            String category = request.getParameter("category");
            query = category == null || category.equals("") ? ", BaseObject as obj where obj.name=doc.fullName and obj.className='Blog.BlogPostClass' and obj.name<>'Blog.BlogPostTemplate' order by doc.creationDate desc" : ", BaseObject as obj, DBStringListProperty as prop join prop.list list where obj.name=doc.fullName and obj.className='Blog.BlogPostClass' and obj.name<>'Blog.BlogPostTemplate' and obj.id=prop.id.id and prop.id.name='category' and list = '" + category + "' order by doc.creationDate desc";
        }
        Map<String, Object> params = Collections.emptyMap();
        Map<String, Object> blogMappings = null;
        if (blogPostClassName == null) {
            blogMappings = BLOG_FIELDS_MAPPING;
        } else {
            blogMappings = new HashMap<String, Object>();
            blogMappings.put("title", blogPostClassName + "_title");
            blogMappings.put("description", blogPostClassName + "_content");
            blogMappings.put("categories", blogPostClassName + "_category");
            blogMappings.put("publishedDate", blogPostClassName + "_publishDate");
            blogMappings.put("ContentLength", new Integer(400));
        }
        SyndFeed blogFeed = this.getFeed(query, count, start, this.getSyndEntrySource(SyndEntryDocumentSource.class.getName(), blogMappings), params, this.fillBlogFeedMetadata(metadata));
        if (blogFeed != null) {
            blogFeed.setImage(this.getDefaultFeedImage());
        }
        return blogFeed;
    }

    public String getFeedOutput(SyndFeed feed, String type) {
        return ((FeedPlugin)this.getProtectedPlugin()).getFeedOutput(feed, type, this.getXWikiContext());
    }

    public String getFeedOutput(List<Object> list, SyndEntrySourceApi sourceApi, Map<String, Object> sourceParams, Map<String, Object> metadata, String type) {
        this.getXWikiContext().remove((Object)FEED_PLUGIN_EXCEPTION);
        try {
            return ((FeedPlugin)this.getProtectedPlugin()).getFeedOutput(list, sourceApi.getSyndEntrySource(), sourceParams, metadata, type, this.getXWikiContext());
        }
        catch (XWikiException e) {
            this.getXWikiContext().put((Object)FEED_PLUGIN_EXCEPTION, (Object)e);
            return null;
        }
    }

    public String getDocumentFeedOutput(List<Object> list, Map<String, Object> params, Map<String, Object> metadata, String type) {
        return this.getFeedOutput(list, this.getSyndEntryDocumentSource(), params, metadata, type);
    }

    public String getArticleFeedOutput(List<Object> list, Map<String, Object> metadata, String type) {
        Map<String, Object> params = Collections.emptyMap();
        return this.getFeedOutput(list, this.getSyndEntryArticleSource(), params, metadata, type);
    }

    public String getWebFeedOutput(List<Object> list, Map<String, Object> metadata, String type) {
        return this.getFeedOutput(this.getWebFeed(list, metadata), type);
    }

    public String getBlogFeedOutput(List<Object> list, Map<String, Object> metadata, String type) {
        return this.getFeedOutput(this.getBlogFeed(list, metadata), type);
    }

    public String getFeedOutput(String query, int count, int start, SyndEntrySourceApi sourceApi, Map<String, Object> sourceParams, Map<String, Object> metadata, String type) {
        this.getXWikiContext().remove((Object)FEED_PLUGIN_EXCEPTION);
        try {
            return ((FeedPlugin)this.getProtectedPlugin()).getFeedOutput(query, count, start, sourceApi.getSyndEntrySource(), sourceParams, metadata, type, this.getXWikiContext());
        }
        catch (XWikiException e) {
            this.getXWikiContext().put((Object)FEED_PLUGIN_EXCEPTION, (Object)e);
            return null;
        }
    }

    public String getDocumentFeedOutput(String query, int count, int start, Map<String, Object> params, Map<String, Object> metadata, String type) {
        return this.getFeedOutput(query, count, start, this.getSyndEntryDocumentSource(), params, metadata, type);
    }

    public String getArticleFeedOutput(String query, int count, int start, Map<String, Object> metadata, String type) {
        Map<String, Object> params = Collections.emptyMap();
        return this.getFeedOutput(query, count, start, this.getSyndEntryArticleSource(), params, metadata, type);
    }

    public String getWebFeedOutput(String query, int count, int start, Map<String, Object> metadata, String type) {
        return this.getFeedOutput(this.getWebFeed(query, count, start, metadata), type);
    }

    public String getBlogFeedOutput(String query, int count, int start, Map<String, Object> metadata, String type) {
        return this.getFeedOutput(this.getBlogFeed(query, count, start, metadata), type);
    }

    public String getBlogFeedOutput(String query, int count, int start, String blogPostClassName, Map<String, Object> metadata, String type) {
        SyndFeed feed = this.getBlogFeed(query, count, start, blogPostClassName, metadata);
        String ret = this.getFeedOutput(feed, type);
        return ret;
    }

    static {
        BLOG_FIELDS_MAPPING.put("title", "Blog.BlogPostClass_title");
        BLOG_FIELDS_MAPPING.put("description", "Blog.BlogPostClass_content");
        BLOG_FIELDS_MAPPING.put("categories", "Blog.BlogPostClass_category");
        BLOG_FIELDS_MAPPING.put("publishedDate", "Blog.BlogPostClass_publishDate");
        BLOG_FIELDS_MAPPING.put("ContentLength", new Integer(400));
    }
}

