/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.git.internal;

import java.io.File;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.environment.Environment;
import org.xwiki.script.service.ScriptService;

@Component
@Named(value="git")
@Singleton
public class GitScriptService
implements ScriptService {
    @Inject
    private Environment environment;
    @Inject
    private Logger logger;

    public Repository getRepository(String repositoryURI, String localDirectoryName) {
        FileRepository repository;
        File localDirectory = new File(this.environment.getPermanentDirectory(), "git/" + localDirectoryName);
        File gitDirectory = new File(localDirectory, ".git");
        this.logger.debug("Local Git repository is at [{}]", (Object)gitDirectory);
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        try {
            repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setGitDir(gitDirectory)).readEnvironment()).findGitDir()).build();
            Git git = new Git((Repository)repository);
            if (!gitDirectory.exists()) {
                git.cloneRepository().setDirectory(localDirectory).setURI(repositoryURI).call();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to execute Git command in [%s]", gitDirectory), e);
        }
        return repository;
    }
}

