/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.git.internal;

import java.io.File;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.gitective.core.CommitFinder;
import org.gitective.core.filter.commit.AndCommitFilter;
import org.gitective.core.filter.commit.AuthorDateFilter;
import org.gitective.core.filter.commit.AuthorSetFilter;
import org.gitective.core.filter.commit.CommitCountFilter;
import org.gitective.core.stat.AuthorHistogramFilter;
import org.gitective.core.stat.CommitCountComparator;
import org.gitective.core.stat.UserCommitActivity;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.environment.Environment;
import org.xwiki.git.GitManager;

@Component
@Singleton
public class DefaultGitManager
implements GitManager {
    @Inject
    private Environment environment;
    @Inject
    private Logger logger;

    @Override
    public Repository getRepository(String repositoryURI, String localDirectoryName) {
        FileRepository repository;
        File localGitDirectory = new File(this.environment.getPermanentDirectory(), "git");
        File localDirectory = new File(localGitDirectory, localDirectoryName);
        File gitDirectory = new File(localDirectory, ".git");
        this.logger.debug("Local Git repository is at [{}]", (Object)gitDirectory);
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        try {
            repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setGitDir(gitDirectory)).readEnvironment()).findGitDir()).build();
            Git git = new Git((Repository)repository);
            if (!gitDirectory.exists()) {
                git.cloneRepository().setDirectory(localDirectory).setURI(repositoryURI).call();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to execute Git command in [%s]", gitDirectory), e);
        }
        return repository;
    }

    @Override
    public Set<PersonIdent> findAuthors(List<Repository> repositories) {
        CommitFinder finder = new CommitFinder(repositories);
        AuthorSetFilter authors = new AuthorSetFilter();
        finder.setFilter((RevFilter)authors).find();
        return authors.getPersons();
    }

    @Override
    public UserCommitActivity[] countAuthorCommits(Date since, List<Repository> repositories) {
        if (repositories.isEmpty()) {
            return new UserCommitActivity[0];
        }
        CommitFinder finder = new CommitFinder(repositories);
        CommitCountFilter countFilter = new CommitCountFilter();
        AuthorHistogramFilter histogramFilter = new AuthorHistogramFilter();
        AuthorSetFilter authorFilter = new AuthorSetFilter();
        AndCommitFilter filters = new AndCommitFilter(new RevFilter[]{countFilter, authorFilter, histogramFilter});
        if (since != null) {
            AuthorDateFilter dateFilter = new AuthorDateFilter(since);
            finder.setFilter((RevFilter)dateFilter);
        }
        finder.setMatcher((RevFilter)filters).find();
        return histogramFilter.getHistogram().getUserActivity((Comparator)new CommitCountComparator());
    }
}

