/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.git.script;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.gitective.core.stat.UserCommitActivity;
import org.joda.time.DateTime;
import org.xwiki.component.annotation.Component;
import org.xwiki.git.GitManager;
import org.xwiki.script.service.ScriptService;
import org.xwiki.stability.Unstable;

@Component
@Named(value="git")
@Singleton
@Unstable
public class GitScriptService
implements ScriptService {
    @Inject
    private GitManager gitManager;

    public Repository getRepository(String repositoryURI, String localDirectoryName) {
        return this.gitManager.getRepository(repositoryURI, localDirectoryName);
    }

    public Set<PersonIdent> findAuthors(Repository ... repositories) {
        return this.gitManager.findAuthors(Arrays.asList(repositories));
    }

    public UserCommitActivity[] countAuthorCommits(int sinceDays, Repository ... repositories) {
        return this.countAuthorCommits(sinceDays, Arrays.asList(repositories));
    }

    public UserCommitActivity[] countAuthorCommits(int sinceDays, List<Repository> repositories) {
        Date date = null;
        if (sinceDays > 0) {
            DateTime now = new DateTime();
            date = now.minusDays(sinceDays).toDate();
        }
        return this.gitManager.countAuthorCommits(date, repositories);
    }
}

