/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.graphviz;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.plugin.XWikiDefaultPlugin;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.graphviz.GraphVizPluginApi;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.environment.Environment;

@Deprecated
public class GraphVizPlugin
extends XWikiDefaultPlugin {
    private static final Pattern HTML_ESCAPE_PATTERN = Pattern.compile("&#([0-9]++);");
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphVizPlugin.class);
    private static final String DEFAULT_FORMAT = "png";
    private static final String DOT_ENGINE = "dot";
    private static final String NEATO_ENGINE = "neato";
    private File tempDir;
    private String dotPath;
    private String neatoPath;
    private Environment environment = (Environment)Utils.getComponent(Environment.class);

    public GraphVizPlugin(String name, String className, XWikiContext context) {
        super(name, className, context);
        this.init(context);
    }

    public String getName() {
        return "graphviz";
    }

    public Api getPluginApi(XWikiPluginInterface plugin, XWikiContext context) {
        return new GraphVizPluginApi((GraphVizPlugin)plugin, context);
    }

    public void flushCache() {
        try {
            FileUtils.cleanDirectory((File)this.tempDir);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void init(XWikiContext context) {
        File dfile2;
        super.init(context);
        File dir = this.environment.getTemporaryDirectory();
        this.tempDir = new File(dir, this.getName());
        try {
            this.tempDir.mkdirs();
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to create temporary file", (Throwable)ex);
        }
        this.dotPath = context.getWiki().Param("xwiki.plugin.graphviz.dotpath", DOT_ENGINE);
        if (!this.dotPath.equals(DOT_ENGINE)) {
            try {
                dfile2 = new File(this.dotPath);
                if (!dfile2.exists()) {
                    LOGGER.error("Cannot find graphiz dot program at " + this.dotPath);
                }
            }
            catch (Exception dfile2) {
                // empty catch block
            }
        }
        this.neatoPath = context.getWiki().Param("xwiki.plugin.graphviz.neatopath", NEATO_ENGINE);
        if (!this.neatoPath.equals(NEATO_ENGINE)) {
            try {
                dfile2 = new File(this.neatoPath);
                if (!dfile2.exists()) {
                    LOGGER.error("Cannot find graphiz neato program at " + this.neatoPath);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getDotImageURL(String content, boolean dot, XWikiContext context) throws IOException {
        return this.getDotResultURL(content, dot, DEFAULT_FORMAT, context);
    }

    public String getDotResultURL(String content, boolean dot, String outputFormat, XWikiContext context) throws IOException {
        String filename = this.writeDotImage(content, outputFormat, dot);
        return context.getDoc().getAttachmentURL(filename, DOT_ENGINE, context);
    }

    public byte[] getDotImage(String content, boolean dot) throws IOException {
        return this.getDotImage(content, DEFAULT_FORMAT, dot);
    }

    public byte[] getDotImage(String content, String extension, boolean dot) throws IOException {
        int hashCode = Math.abs(content.hashCode());
        return this.getDotImage(hashCode, content, extension, dot);
    }

    public String writeDotImage(String content, boolean dot) throws IOException {
        return this.writeDotImage(content, DEFAULT_FORMAT, dot);
    }

    public String writeDotImage(String content, String extension, boolean dot) throws IOException {
        int hashCode = Math.abs(content.hashCode());
        this.getDotImage(hashCode, content, extension, dot);
        String name = (dot ? DOT_ENGINE : NEATO_ENGINE) + '-';
        return name + hashCode + "." + extension;
    }

    public void outputDotImage(String content, boolean dot, XWikiContext context) throws IOException {
        this.outputDotImage(content, DEFAULT_FORMAT, dot, context);
    }

    public void outputDotImage(String content, String extension, boolean dot, XWikiContext context) throws IOException {
        byte[] dotbytes = this.getDotImage(content, extension, dot);
        XWikiResponse response = context.getResponse();
        context.setFinished(true);
        response.setContentLength(dotbytes.length);
        response.setContentType(context.getEngineContext().getMimeType("toto." + extension));
        ServletOutputStream os = response.getOutputStream();
        os.write(dotbytes);
        os.flush();
    }

    public void outputDotImageFromFile(String filename, XWikiContext context) throws IOException {
        File ofile = this.getTempFile(filename);
        byte[] dotbytes = this.readDotImage(ofile);
        XWikiResponse response = context.getResponse();
        context.setFinished(true);
        response.setDateHeader("Last-Modified", ofile.lastModified());
        response.setContentLength(dotbytes.length);
        response.setContentType(context.getEngineContext().getMimeType(filename));
        ServletOutputStream os = response.getOutputStream();
        os.write(dotbytes);
    }

    private byte[] getDotImage(int hashCode, String content, String extension, boolean dot) throws IOException {
        File ofile;
        File dfile = this.getTempFile(hashCode, "input.dot", dot);
        if (!dfile.exists()) {
            FileUtils.write((File)dfile, (CharSequence)this.undoEscapeFilter(content), (String)"UTF-8");
        }
        if (!(ofile = this.getTempFile(hashCode, extension, dot)).exists()) {
            Runtime rt = Runtime.getRuntime();
            String[] command = new String[]{dot ? this.dotPath : this.neatoPath, "-T" + extension, dfile.getAbsolutePath(), "-o", ofile.getAbsolutePath()};
            Process p = rt.exec(command);
            int exitValue = -1;
            Thread thisThread = Thread.currentThread();
            Thread t = new Thread((Runnable)new Hangcheck(thisThread), "dot-hangcheck");
            t.run();
            try {
                exitValue = p.waitFor();
                t.interrupt();
            }
            catch (InterruptedException ex) {
                p.destroy();
                LOGGER.error("Timeout while generating image from dot", (Throwable)ex);
            }
            if (exitValue != 0) {
                LOGGER.error("Error while generating image from dot: " + IOUtils.toString((InputStream)p.getErrorStream(), (String)"UTF-8"));
            }
        }
        return FileUtils.readFileToByteArray((File)ofile);
    }

    private byte[] readDotImage(File ofile) throws IOException {
        return FileUtils.readFileToByteArray((File)ofile);
    }

    private File getTempFile(int hashcode, String extension, boolean dot) {
        String name = (dot ? DOT_ENGINE : NEATO_ENGINE) + '-';
        return this.getTempFile(name + hashcode + '.' + extension);
    }

    private File getTempFile(String filename) {
        return new File(this.tempDir, filename);
    }

    private String undoEscapeFilter(String escapedContent) {
        if (StringUtils.isNotEmpty((CharSequence)escapedContent)) {
            Matcher matcher = HTML_ESCAPE_PATTERN.matcher(escapedContent);
            StringBuffer result = new StringBuffer(escapedContent.length());
            while (matcher.find()) {
                int codepoint = Integer.valueOf(matcher.group(1));
                if (codepoint >= 65 && codepoint <= 122) {
                    matcher.appendReplacement(result, new String(new int[]{92, 92, codepoint}, 0, 3));
                    continue;
                }
                matcher.appendReplacement(result, "$0");
            }
            matcher.appendTail(result);
            return result.toString();
        }
        return "";
    }

    private static class Hangcheck
    implements Runnable {
        private Thread converterThread;

        Hangcheck(Thread converterThread) {
            this.converterThread = converterThread;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(10000L);
                this.converterThread.interrupt();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

