/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.gwt.api.client.app;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import com.xpn.xwiki.gwt.api.client.XWikiGWTException;
import com.xpn.xwiki.gwt.api.client.XWikiService;
import com.xpn.xwiki.gwt.api.client.XWikiServiceAsync;
import com.xpn.xwiki.gwt.api.client.app.Translator;
import com.xpn.xwiki.gwt.api.client.app.XWikiGWTApp;
import com.xpn.xwiki.gwt.api.client.dialog.LoadingDialog;
import com.xpn.xwiki.gwt.api.client.dialog.ModalMessageDialog;
import java.util.HashMap;
import java.util.Map;

public class XWikiGWTDefaultApp
implements XWikiGWTApp {
    protected Translator translator;
    protected LoadingDialog loadingDialog = new LoadingDialog(this);
    protected XWikiServiceAsync serviceInstance;
    protected String name;
    protected static Map _metaPropertiesMap = null;

    public void onModuleLoad() {
    }

    @Override
    public String getName() {
        return this.name == null ? "app" : this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private static native Map getMetaProperties(Map var0);

    public static String getProperty(String name) {
        if (_metaPropertiesMap == null) {
            _metaPropertiesMap = XWikiGWTDefaultApp.getMetaProperties(new HashMap());
        }
        return (String)_metaPropertiesMap.get(name);
    }

    public String getParam(String key) {
        return this.getParam(key, "");
    }

    public String getParam(String key, String defaultValue) {
        String param = XWikiGWTDefaultApp.getProperty(key);
        if (param == null || param.equals("")) {
            return defaultValue;
        }
        return param;
    }

    public int getParamAsInt(String key) {
        return this.getParamAsInt(key, 0);
    }

    public int getParamAsInt(String key, int defaultValue) {
        String param = this.getParam(key);
        if (param == null || param.equals("")) {
            return defaultValue;
        }
        return Integer.parseInt(param);
    }

    @Override
    public String getTranslationPage() {
        return this.getParam("translations", "XWiki.Translations");
    }

    public String getSkinBaseURL() {
        String skinbaseurl = this.getParam("skinbaseurl");
        if (skinbaseurl.equals("")) {
            String skin = this.getSkin();
            return "/xwiki/bin/skin/" + skin;
        }
        return skinbaseurl;
    }

    public String getSkin() {
        return this.getParam("skin", "colibri");
    }

    @Override
    public String getTranslation(String key) {
        if (this.translator != null) {
            return this.translator.getTranslation(this.getName() + "." + key);
        }
        return key;
    }

    @Override
    public String getTranslation(String key, String[] args) {
        if (this.translator != null) {
            return this.translator.getTranslation(this.getName() + "." + key, args);
        }
        return key;
    }

    @Override
    public XWikiServiceAsync getXWikiServiceInstance() {
        if (this.serviceInstance == null) {
            String moduleBaseURL = GWT.getModuleBaseURL();
            String baseURL = moduleBaseURL.substring(0, moduleBaseURL.indexOf(GWT.getModuleName()) - 1);
            String defaultXWikiService = baseURL + "/XWikiService";
            this.serviceInstance = (XWikiServiceAsync)GWT.create(XWikiService.class);
            ((ServiceDefTarget)this.serviceInstance).setServiceEntryPoint(this.getParam("xwikiservice", defaultXWikiService));
        }
        return this.serviceInstance;
    }

    @Override
    public String getSkinFile(String file) {
        return this.getSkinBaseURL() + "/" + file;
    }

    private LoadingDialog getLoadingDialog() {
        return this.loadingDialog;
    }

    @Override
    public void startLoading() {
        this.getLoadingDialog().startLoading();
    }

    @Override
    public void finishLoading() {
        this.getLoadingDialog().finishLoading();
    }

    @Override
    public boolean isTranslatorLoaded() {
        return this.translator != null;
    }

    public void checkTranslator(AsyncCallback cback) {
        if (this.translator == null) {
            this.getLoadingDialog().disable();
            this.translator = new Translator(this);
            this.translator.init(cback);
            this.getLoadingDialog().enable();
        } else if (cback != null) {
            cback.onSuccess(null);
        }
    }

    @Override
    public void showDialog(String title, String message) {
        new ModalMessageDialog(this, title, message);
    }

    @Override
    public void showDialog(String message) {
        new ModalMessageDialog(this, this.getTranslation("appname"), message);
    }

    @Override
    public void showError(Throwable caught) {
        if (caught instanceof XWikiGWTException) {
            XWikiGWTException exp = (XWikiGWTException)caught;
            if (exp.getCode() == 9002) {
                this.showDialog(this.getTranslation("login_first"));
            } else if (exp.getCode() == 9001) {
                this.showDialog(this.getTranslation("missing_rights"));
            } else {
                this.showError("" + exp.getCode(), exp.getFullMessage());
            }
        } else {
            if (caught != null) {
                caught.printStackTrace();
            }
            this.showError("", caught == null ? "" : caught.toString());
        }
    }

    @Override
    public void showError(String text) {
        this.showError("", text);
    }

    @Override
    public void showError(String code, String text) {
        String[] args = new String[]{code};
        String message = this.getTranslation("errorwithcode", args) + "\r\n\r\n" + text;
        this.showDialog(message);
    }

    @Override
    public String getCSSPrefix() {
        return this.getParam("cssprefix", "xwikigwt");
    }

    public static native String getUserAgent();

    public static boolean isMSIE() {
        return XWikiGWTDefaultApp.getUserAgent().indexOf("MSIE") != -1;
    }

    public static boolean isGecki() {
        return XWikiGWTDefaultApp.getUserAgent().indexOf("Gecko") != -1;
    }

    public static boolean isSafari() {
        return XWikiGWTDefaultApp.getUserAgent().indexOf("Safari") != -1;
    }

    public static int getAbsoluteTop(Widget widget) {
        if (XWikiGWTDefaultApp.isMSIE()) {
            return widget.getAbsoluteTop();
        }
        if (widget instanceof ScrollPanel) {
            return widget.getAbsoluteTop() + ((ScrollPanel)widget).getScrollPosition();
        }
        return widget.getAbsoluteTop();
    }

    public static void setMaxHeight(Widget widget) {
        int absoluteTop = XWikiGWTDefaultApp.getAbsoluteTop(widget);
        int newHeight = Window.getClientHeight() - absoluteTop;
        if (newHeight > 0) {
            try {
                widget.setHeight(newHeight + "px");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public String getLocale() {
        return this.getParam("locale", "en");
    }
}

