/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.icon.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.icon.IconException;
import org.xwiki.icon.IconSet;
import org.xwiki.icon.IconSetCache;
import org.xwiki.icon.IconSetLoader;
import org.xwiki.icon.IconSetManager;
import org.xwiki.icon.internal.context.IconSetContext;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Singleton
public class DefaultIconSetManager
implements IconSetManager {
    private static final String DEFAULT_ICONSET_NAME = "default";
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private IconSetCache iconSetCache;
    @Inject
    private IconSetLoader iconSetLoader;
    @Inject
    private IconSetContext iconSetContext;
    @Inject
    private QueryManager queryManager;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    @Named(value="all")
    private ConfigurationSource configurationSource;

    public IconSet getCurrentIconSet() throws IconException {
        IconSet iconSet = this.iconSetContext.getIconSet();
        if (iconSet != null) {
            return iconSet;
        }
        String iconTheme = (String)this.configurationSource.getProperty("iconTheme");
        DocumentReference iconThemeDocRef = this.documentReferenceResolver.resolve((Object)iconTheme, new Object[0]);
        if (!StringUtils.isBlank((CharSequence)iconTheme) && this.documentAccessBridge.exists(iconThemeDocRef) && (iconSet = this.iconSetCache.get(iconThemeDocRef)) == null) {
            iconSet = this.iconSetLoader.loadIconSet(iconThemeDocRef);
            this.iconSetCache.put(iconThemeDocRef, iconSet);
            this.iconSetCache.put(iconSet.getName(), this.wikiDescriptorManager.getCurrentWikiId(), iconSet);
        }
        return iconSet;
    }

    public IconSet getDefaultIconSet() throws IconException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWiki xwiki = xcontext.getWiki();
        IconSet iconSet = this.iconSetCache.get(DEFAULT_ICONSET_NAME);
        if (iconSet == null) {
            try (InputStreamReader reader = new InputStreamReader(xwiki.getResourceAsStream("/resources/icons/default.iconset"));){
                iconSet = this.iconSetLoader.loadIconSet((Reader)reader, DEFAULT_ICONSET_NAME);
                this.iconSetCache.put(DEFAULT_ICONSET_NAME, iconSet);
            }
            catch (IOException e) {
                throw new IconException("Failed to load the current default icon set resource.", (Throwable)e);
            }
            catch (IconException e) {
                throw new IconException("Failed to get the current default icon set.", (Throwable)e);
            }
        }
        return iconSet;
    }

    public IconSet getIconSet(String name) throws IconException {
        if (DEFAULT_ICONSET_NAME.equals(name)) {
            return this.getDefaultIconSet();
        }
        IconSet iconSet = this.iconSetCache.get(name, this.wikiDescriptorManager.getCurrentWikiId());
        if (iconSet == null) {
            try {
                String xwql = "FROM doc.object(IconThemesCode.IconThemeClass) obj WHERE obj.name = :name";
                Query query = this.queryManager.createQuery(xwql, "xwql");
                query.bindValue("name", (Object)name);
                List results = query.execute();
                if (results.isEmpty()) {
                    return null;
                }
                String docName = (String)results.get(0);
                DocumentReference docRef = this.documentReferenceResolver.resolve((Object)docName, new Object[0]);
                iconSet = this.iconSetLoader.loadIconSet(docRef);
                this.iconSetCache.put(docRef, iconSet);
                this.iconSetCache.put(name, this.wikiDescriptorManager.getCurrentWikiId(), iconSet);
            }
            catch (QueryException e) {
                throw new IconException(String.format("Failed to load the icon set [%s].", name), (Throwable)e);
            }
        }
        return iconSet;
    }

    public List<String> getIconSetNames() throws IconException {
        try {
            String xwql = "SELECT obj.name FROM Document doc, doc.object(IconThemesCode.IconThemeClass) obj ORDER BY obj.name";
            Query query = this.queryManager.createQuery(xwql, "xwql");
            return query.execute();
        }
        catch (QueryException e) {
            throw new IconException("Failed to get the name of all icon sets.", (Throwable)e);
        }
    }
}

