/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.tree.internal.nestedpages;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.index.tree.internal.AbstractEntityTreeNode;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;

public abstract class AbstractDocumentTreeNode
extends AbstractEntityTreeNode {
    private final String nodeType;

    public AbstractDocumentTreeNode(String nodeType) {
        this.nodeType = nodeType;
    }

    public List<String> getChildren(String nodeId, int offset, int limit) {
        EntityReference documentReference = this.resolve(nodeId);
        if (documentReference != null && documentReference.getType() == EntityType.DOCUMENT) {
            try {
                return this.getChildren(new DocumentReference(documentReference), offset, limit);
            }
            catch (Exception e) {
                this.logger.warn("Failed to retrieve the children of [{}]. Root cause [{}].", (Object)nodeId, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        return Collections.emptyList();
    }

    protected List<String> getChildren(DocumentReference documentReference, int offset, int limit) throws Exception {
        return Collections.emptyList();
    }

    public int getChildCount(String nodeId) {
        EntityReference documentReference = this.resolve(nodeId);
        if (documentReference != null && documentReference.getType() == EntityType.DOCUMENT) {
            try {
                return this.getChildCount(new DocumentReference(documentReference));
            }
            catch (Exception e) {
                this.logger.warn("Failed to count the children of [{}]. Root cause [{}].", (Object)nodeId, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        return 0;
    }

    protected int getChildCount(DocumentReference documentReference) throws Exception {
        return 0;
    }

    public String getParent(String nodeId) {
        EntityReference documentReference = this.resolve(nodeId);
        if (documentReference != null && documentReference.getType() == EntityType.DOCUMENT) {
            try {
                return this.serialize(this.getParent(new DocumentReference(documentReference)));
            }
            catch (Exception e) {
                this.logger.warn("Failed to retrieve the parent of [{}]. Root cause [{}].", (Object)nodeId, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        return null;
    }

    protected EntityReference getParent(DocumentReference documentReference) throws Exception {
        return documentReference;
    }

    @Override
    protected EntityReference resolve(String nodeId) {
        String prefix = this.nodeType + ':';
        if (StringUtils.startsWith((CharSequence)nodeId, (CharSequence)prefix)) {
            return super.resolve("document:" + nodeId.substring(prefix.length()));
        }
        return null;
    }
}

