/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.tree.internal.nestedpages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.index.tree.internal.nestedpages.AbstractDocumentTreeNode;
import org.xwiki.localization.LocalizationContext;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.tree.TreeNode;

@Component
@Named(value="document")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DocumentTreeNode
extends AbstractDocumentTreeNode
implements Initializable {
    private static final String FIELD_TITLE = "title";
    private static final String PARAMETER_LOCALE = "locale";
    private static final String PARAMETER_EXCLUDED_DOCUMENTS = "excludedDocuments";
    @Inject
    @Named(value="count")
    protected QueryFilter countQueryFilter;
    @Inject
    @Named(value="hidden/document")
    protected Provider<QueryFilter> hiddenDocumentQueryFilterProvider;
    @Inject
    private LocalizationContext localizationContext;
    @Inject
    private ContextualAuthorizationManager authorization;
    @Inject
    @Named(value="childPage/nestedPages")
    private QueryFilter childPageFilter;
    @Inject
    @Named(value="hiddenPage/nestedPages")
    private QueryFilter hiddenPageFilter;
    @Inject
    @Named(value="excludedSpace/nestedPages")
    private QueryFilter excludedSpaceFilter;
    @Inject
    @Named(value="excludedDocument/nestedPages")
    private QueryFilter excludedDocumentFilter;
    @Inject
    @Named(value="documentReferenceResolver/nestedPages")
    private QueryFilter documentReferenceResolverFilter;
    private Map<String, TreeNode> nonLeafChildNodes = new LinkedHashMap<String, TreeNode>();

    public DocumentTreeNode() {
        super("document");
    }

    public void initialize() throws InitializationException {
        String[] nonLeafChildNodeTypes = new String[]{"translations", "attachments", "classProperties", "objects"};
        ComponentManager contextComponentManager = (ComponentManager)this.contextComponentManagerProvider.get();
        try {
            for (String nonLeafChildNodeType : nonLeafChildNodeTypes) {
                TreeNode treeNode = (TreeNode)contextComponentManager.getInstance(TreeNode.class, nonLeafChildNodeType);
                this.nonLeafChildNodes.put(nonLeafChildNodeType, treeNode);
            }
        }
        catch (ComponentLookupException e) {
            throw new InitializationException("Failed to lookup the child components.", (Throwable)e);
        }
    }

    @Override
    protected List<String> getChildren(DocumentReference documentReference, int offset, int limit) throws Exception {
        int childDocumentsLimit;
        ArrayList<String> children = new ArrayList<String>();
        List<String> pseudoChildren = this.getPseudoChildren(documentReference);
        if (offset < pseudoChildren.size()) {
            int start = Math.min(Math.max(offset, 0), pseudoChildren.size());
            int end = Math.max(Math.min(start + limit, pseudoChildren.size()), start);
            children.addAll(pseudoChildren.subList(start, end));
        }
        if ((childDocumentsLimit = limit - children.size()) > 0) {
            int childDocumentsOffset = Math.max(offset - pseudoChildren.size(), 0);
            children.addAll(this.serialize(this.getChildDocuments(documentReference, childDocumentsOffset, childDocumentsLimit)));
        }
        return children;
    }

    private List<String> getPseudoChildren(DocumentReference documentReference) {
        ArrayList<String> pseudoChildren = new ArrayList<String>();
        String serializedDocRef = (String)this.defaultEntityReferenceSerializer.serialize((EntityReference)documentReference, new Object[0]);
        for (Map.Entry<String, TreeNode> entry : this.nonLeafChildNodes.entrySet()) {
            if (!this.hasChild(entry.getKey(), entry.getValue(), documentReference)) continue;
            pseudoChildren.add(entry.getKey() + ':' + serializedDocRef);
        }
        if (this.showAddDocument(documentReference)) {
            pseudoChildren.add("addDocument:" + serializedDocRef);
        }
        return pseudoChildren;
    }

    protected List<DocumentReference> getChildDocuments(DocumentReference documentReference, int offset, int limit) throws QueryException {
        Set<String> excludedSpaces;
        Query query;
        if (!this.getDefaultDocumentName().equals(documentReference.getName())) {
            return Collections.emptyList();
        }
        String orderBy = this.getOrderBy();
        if (this.areTerminalDocumentsShown()) {
            if (FIELD_TITLE.equals(orderBy)) {
                query = this.queryManager.getNamedQuery("nestedPagesOrderedByTitle");
                query.bindValue(PARAMETER_LOCALE, (Object)this.localizationContext.getCurrentLocale().toString());
            } else {
                query = this.queryManager.getNamedQuery("nestedPagesOrderedByName");
            }
            Set<String> excludedDocuments = this.getExcludedDocuments(documentReference.getParent());
            if (!excludedDocuments.isEmpty()) {
                query.bindValue(PARAMETER_EXCLUDED_DOCUMENTS, excludedDocuments);
                query.addFilter(this.excludedDocumentFilter);
            }
        } else if (FIELD_TITLE.equals(orderBy)) {
            query = this.queryManager.getNamedQuery("nonTerminalPagesOrderedByTitle");
            query.bindValue(PARAMETER_LOCALE, (Object)this.localizationContext.getCurrentLocale().toString());
        } else {
            query = this.queryManager.createQuery("select reference, 0 as terminal from XWikiSpace page order by lower(name), name", "hql");
        }
        query.setWiki(documentReference.getWikiReference().getName());
        query.setOffset(offset);
        query.setLimit(limit);
        query.addFilter(this.childPageFilter);
        query.bindValue("parent", this.localEntityReferenceSerializer.serialize(documentReference.getParent(), new Object[0]));
        if (!this.areHiddenEntitiesShown()) {
            query.addFilter(this.hiddenPageFilter);
        }
        if (!(excludedSpaces = this.getExcludedSpaces(documentReference.getParent())).isEmpty()) {
            query.bindValue("excludedSpaces", excludedSpaces);
            query.addFilter(this.excludedSpaceFilter);
        }
        return query.addFilter(this.documentReferenceResolverFilter).execute();
    }

    @Override
    protected int getChildCount(DocumentReference documentReference) throws Exception {
        return this.getPseudoChildCount(documentReference) + this.getChildDocumentsCount(documentReference);
    }

    private int getPseudoChildCount(DocumentReference documentReference) {
        int count = 0;
        for (Map.Entry<String, TreeNode> entry : this.nonLeafChildNodes.entrySet()) {
            if (!this.hasChild(entry.getKey(), entry.getValue(), documentReference)) continue;
            ++count;
        }
        if (this.showAddDocument(documentReference)) {
            ++count;
        }
        return count;
    }

    protected int getChildDocumentsCount(DocumentReference documentReference) throws QueryException {
        if (!this.getDefaultDocumentName().equals(documentReference.getName())) {
            return 0;
        }
        int count = this.getChildSpacesCount((EntityReference)documentReference);
        if (this.areTerminalDocumentsShown()) {
            count += this.getChildTerminalPagesCount(documentReference);
        }
        return count;
    }

    private int getChildTerminalPagesCount(DocumentReference documentReference) throws QueryException {
        ArrayList<String> constraints = new ArrayList<String>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        constraints.add("doc.translation = 0");
        constraints.add("doc.space = :space");
        parameters.put("space", this.localEntityReferenceSerializer.serialize(documentReference.getParent(), new Object[0]));
        constraints.add("doc.name <> :defaultDocName");
        parameters.put("defaultDocName", this.getDefaultDocumentName());
        Set<String> excludedDocuments = this.getExcludedDocuments(documentReference.getParent());
        if (!excludedDocuments.isEmpty()) {
            constraints.add("doc.fullName not in (:excludedDocuments)");
            parameters.put(PARAMETER_EXCLUDED_DOCUMENTS, excludedDocuments);
        }
        Query query = this.queryManager.createQuery(this.whereClause(constraints), "hql");
        query.setWiki(documentReference.getWikiReference().getName());
        for (Map.Entry entry : parameters.entrySet()) {
            query.bindValue((String)entry.getKey(), entry.getValue());
        }
        query.addFilter(this.countQueryFilter);
        if (Boolean.TRUE.equals(this.getProperties().get("filterHiddenDocuments"))) {
            query.addFilter((QueryFilter)this.hiddenDocumentQueryFilterProvider.get());
        }
        return ((Long)query.execute().get(0)).intValue();
    }

    @Override
    protected EntityReference getParent(DocumentReference documentReference) throws Exception {
        if (this.getDefaultDocumentName().equals(documentReference.getName())) {
            EntityReference parentReference = documentReference.getParent().getParent();
            if (parentReference.getType() == EntityType.SPACE) {
                return new DocumentReference(this.getDefaultDocumentName(), new SpaceReference(parentReference));
            }
            return parentReference;
        }
        return new DocumentReference(this.getDefaultDocumentName(), documentReference.getLastSpaceReference());
    }

    private boolean showAddDocument(DocumentReference documentReference) {
        return Boolean.TRUE.equals(this.getProperties().get("showAddDocument")) && "reference".equals(this.getProperties().get("hierarchyMode")) && this.getDefaultDocumentName().equals(documentReference.getName()) && this.authorization.hasAccess(Right.EDIT, documentReference.getParent());
    }

    private boolean hasChild(String nodeType, TreeNode childNode, DocumentReference documentReference) {
        return this.hasChild(nodeType, childNode, (String)this.defaultEntityReferenceSerializer.serialize((EntityReference)documentReference, new Object[0]));
    }

    private boolean hasChild(String nodeType, TreeNode childNode, String serializedDocumentReference) {
        String showChild = "show" + StringUtils.capitalize((String)nodeType);
        if (Boolean.TRUE.equals(this.getProperties().get(showChild))) {
            String nodeId = nodeType + ':' + serializedDocumentReference;
            childNode.getProperties().putAll(this.getProperties());
            return childNode.getChildCount(nodeId) > 0;
        }
        return false;
    }
}

