/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.tree.internal.nestedpages;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseObjectReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.index.tree.internal.AbstractEntityTreeNode;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.ObjectPropertyReference;
import org.xwiki.model.reference.ObjectReference;

@Component
@Named(value="object")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class ObjectTreeNode
extends AbstractEntityTreeNode {
    @Inject
    private Provider<XWikiContext> xcontextProvider;

    public List<String> getChildren(String nodeId, int offset, int limit) {
        EntityReference objectReference = this.resolve(nodeId);
        if (objectReference != null && objectReference.getType() == EntityType.OBJECT) {
            try {
                return this.serialize(this.getChildren((ObjectReference)new BaseObjectReference(objectReference), offset, limit));
            }
            catch (Exception e) {
                this.logger.warn("Failed to retrieve the children of [{}]. Root cause is [{}].", (Object)nodeId, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        return Collections.emptyList();
    }

    private List<ObjectPropertyReference> getChildren(ObjectReference objectReference, int offset, int limit) throws Exception {
        ArrayList<ObjectPropertyReference> children = new ArrayList<ObjectPropertyReference>();
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument document = xcontext.getWiki().getDocument(objectReference.getParent(), xcontext);
        BaseObject object = document.getXObject(objectReference);
        if (object != null) {
            ArrayList properties = new ArrayList(object.getPropertyList());
            Collections.sort(properties);
            for (String property : this.subList(properties, offset, limit)) {
                children.add(new ObjectPropertyReference(property, objectReference));
            }
        }
        return children;
    }

    public int getChildCount(String nodeId) {
        EntityReference objectReference = this.resolve(nodeId);
        if (objectReference != null && objectReference.getType() == EntityType.OBJECT) {
            try {
                return this.getChildCount((ObjectReference)new BaseObjectReference(objectReference));
            }
            catch (Exception e) {
                this.logger.warn("Failed to count the children of [{}]. Root cause is [{}].", (Object)nodeId, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        return 0;
    }

    private int getChildCount(ObjectReference objectReference) throws Exception {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument document = xcontext.getWiki().getDocument(objectReference.getParent(), xcontext);
        BaseObject object = document.getXObject(objectReference);
        return object == null ? 0 : object.getPropertyList().size();
    }

    public String getParent(String nodeId) {
        EntityReference objectReference = this.resolve(nodeId);
        if (objectReference != null && objectReference.getType() == EntityType.OBJECT) {
            DocumentReference classReference = new BaseObjectReference(objectReference).getXClassReference();
            return "objectsOfType:" + (String)this.defaultEntityReferenceSerializer.serialize(objectReference.getParent(), new Object[0]) + (String)this.defaultEntityReferenceSerializer.serialize((EntityReference)classReference, new Object[0]);
        }
        return null;
    }
}

