/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.tree.internal.nestedpages;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.index.tree.internal.nestedpages.AbstractDocumentTreeNode;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;

@Component
@Named(value="objects")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class ObjectsTreeNode
extends AbstractDocumentTreeNode {
    @Inject
    private Provider<XWikiContext> xcontextProvider;

    public ObjectsTreeNode() {
        super("objects");
    }

    @Override
    protected List<String> getChildren(DocumentReference documentReference, int offset, int limit) throws Exception {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument document = xcontext.getWiki().getDocument(documentReference, xcontext);
        String serializedDocRef = (String)this.defaultEntityReferenceSerializer.serialize((EntityReference)documentReference, new Object[0]);
        ArrayList<Object> classNames = new ArrayList<Object>();
        for (DocumentReference classReference : document.getXObjects().keySet()) {
            classNames.add(this.defaultEntityReferenceSerializer.serialize((EntityReference)classReference, new Object[0]));
        }
        Collections.sort(classNames);
        ArrayList<String> children = new ArrayList<String>();
        for (String className : this.subList(classNames, offset, limit)) {
            children.add("objectsOfType:" + serializedDocRef + "/" + className);
        }
        return children;
    }

    @Override
    protected int getChildCount(DocumentReference documentReference) throws Exception {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument document = xcontext.getWiki().getDocument(documentReference, xcontext);
        return document.getXObjects().size();
    }
}

