/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.tree.internal.nestedpages;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.index.tree.internal.AbstractEntityTreeNode;
import org.xwiki.localization.LocalizationContext;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;

@Component
@Named(value="wiki")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class WikiTreeNode
extends AbstractEntityTreeNode {
    @Inject
    private LocalizationContext localizationContext;
    @Inject
    @Named(value="topLevelPage/nestedPages")
    private QueryFilter topLevelPageFilter;
    @Inject
    @Named(value="hiddenPage/nestedPages")
    private QueryFilter hiddenPageFilter;
    @Inject
    @Named(value="excludedSpace/nestedPages")
    private QueryFilter excludedSpaceFilter;
    @Inject
    @Named(value="documentReferenceResolver/nestedPages")
    private QueryFilter documentReferenceResolverFilter;

    public List<String> getChildren(String nodeId, int offset, int limit) {
        EntityReference wikiReference = this.resolve(nodeId);
        if (wikiReference != null && wikiReference.getType() == EntityType.WIKI) {
            try {
                return this.serialize(this.getChildren(new WikiReference(wikiReference), offset, limit));
            }
            catch (QueryException e) {
                this.logger.warn("Failed to retrieve the children of [{}]. Root cause [{}].", (Object)nodeId, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        return Collections.emptyList();
    }

    protected List<? extends EntityReference> getChildren(WikiReference wikiReference, int offset, int limit) throws QueryException {
        Query query;
        String orderBy = this.getOrderBy();
        if ("title".equals(orderBy)) {
            query = this.queryManager.getNamedQuery("nonTerminalPagesOrderedByTitle");
            query.bindValue("locale", (Object)this.localizationContext.getCurrentLocale().toString());
        } else {
            query = this.queryManager.createQuery("select reference, 0 as terminal from XWikiSpace page order by lower(name), name", "hql");
        }
        query.setWiki(wikiReference.getName());
        query.setOffset(offset);
        query.setLimit(limit);
        Set<String> excludedSpaces = this.getExcludedSpaces((EntityReference)wikiReference);
        if (!excludedSpaces.isEmpty()) {
            query.bindValue("excludedSpaces", excludedSpaces);
            query.addFilter(this.excludedSpaceFilter);
        }
        query.addFilter(this.topLevelPageFilter);
        if (!this.areHiddenEntitiesShown()) {
            query.addFilter(this.hiddenPageFilter);
        }
        return query.addFilter(this.documentReferenceResolverFilter).execute();
    }

    public int getChildCount(String nodeId) {
        EntityReference wikiReference = this.resolve(nodeId);
        if (wikiReference != null && wikiReference.getType() == EntityType.WIKI) {
            try {
                return this.getChildCount(new WikiReference(wikiReference));
            }
            catch (QueryException e) {
                this.logger.warn("Failed to count the children of [{}]. Root cause [{}].", (Object)nodeId, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        return 0;
    }

    protected int getChildCount(WikiReference wikiReference) throws QueryException {
        return this.getChildSpacesCount((EntityReference)wikiReference);
    }

    public String getParent(String nodeId) {
        return "farm:*";
    }
}

