/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.tree.internal.nestedspaces;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.index.tree.internal.AbstractEntityTreeNode;
import org.xwiki.localization.LocalizationContext;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;

@Component
@Named(value="space")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class SpaceTreeNode
extends AbstractEntityTreeNode {
    @Inject
    private LocalizationContext localizationContext;
    @Inject
    @Named(value="hidden/document")
    private Provider<QueryFilter> hiddenDocumentQueryFilterProvider;
    @Inject
    @Named(value="count")
    private QueryFilter countQueryFilter;
    @Inject
    @Named(value="childPage/nestedPages")
    private QueryFilter childPageFilter;
    @Inject
    @Named(value="hiddenPage/nestedPages")
    private QueryFilter hiddenPageFilter;
    @Inject
    @Named(value="documentOrSpaceReferenceResolver/nestedSpaces")
    private QueryFilter documentOrSpaceReferenceResolverFilter;

    public List<String> getChildren(String nodeId, int offset, int limit) {
        EntityReference spaceReference = this.resolve(nodeId);
        if (spaceReference != null && spaceReference.getType() == EntityType.SPACE) {
            try {
                return this.serialize(this.getChildren(new SpaceReference(spaceReference), offset, limit));
            }
            catch (QueryException e) {
                this.logger.warn("Failed to retrieve the children of [{}]. Root cause [{}].", (Object)nodeId, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        return Collections.emptyList();
    }

    protected List<? extends EntityReference> getChildren(SpaceReference spaceReference, int offset, int limit) throws QueryException {
        return this.getChildrenQuery(spaceReference, offset, limit).execute();
    }

    protected Query getChildrenQuery(SpaceReference spaceReference, int offset, int limit) throws QueryException {
        Query query;
        String orderBy = this.getOrderBy();
        if (this.areTerminalDocumentsShown()) {
            if ("title".equals(orderBy)) {
                query = this.queryManager.getNamedQuery("nestedSpacesOrderedByTitle");
                query.bindValue("locale", (Object)this.localizationContext.getCurrentLocale().toString());
            } else {
                query = this.queryManager.getNamedQuery("nestedSpacesOrderedByName");
            }
        } else {
            query = this.queryManager.createQuery("select reference, 0 as terminal from XWikiSpace page order by lower(name), name", "hql");
        }
        query.setWiki(spaceReference.getWikiReference().getName());
        query.setOffset(offset);
        query.setLimit(limit);
        query.addFilter(this.childPageFilter);
        query.bindValue("parent", this.localEntityReferenceSerializer.serialize((EntityReference)spaceReference, new Object[0]));
        if (!this.areHiddenEntitiesShown()) {
            query.addFilter(this.hiddenPageFilter);
        }
        query.addFilter(this.documentOrSpaceReferenceResolverFilter);
        return query;
    }

    public int getChildCount(String nodeId) {
        EntityReference spaceReference = this.resolve(nodeId);
        if (spaceReference != null && spaceReference.getType() == EntityType.SPACE) {
            try {
                return this.getChildCount(new SpaceReference(spaceReference));
            }
            catch (QueryException e) {
                this.logger.warn("Failed to count the children of [{}]. Root cause [{}].", (Object)nodeId, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        return 0;
    }

    protected int getChildCount(SpaceReference spaceReference) throws QueryException {
        int count = this.getChildSpacesCount((EntityReference)spaceReference);
        if (this.areTerminalDocumentsShown()) {
            count += this.getChildDocumentsCount(spaceReference);
        }
        return count;
    }

    protected int getChildDocumentsCount(SpaceReference spaceReference) throws QueryException {
        ArrayList<String> constraints = new ArrayList<String>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        return this.getChildDocumentsCount(spaceReference, constraints, parameters);
    }

    protected int getChildDocumentsCount(SpaceReference spaceReference, List<String> constraints, Map<String, Object> parameters) throws QueryException {
        constraints.add("doc.translation = 0");
        constraints.add("doc.space = :space");
        parameters.put("space", this.localEntityReferenceSerializer.serialize((EntityReference)spaceReference, new Object[0]));
        Query query = this.queryManager.createQuery(this.whereClause(constraints), "hql");
        query.addFilter(this.countQueryFilter);
        if (Boolean.TRUE.equals(this.getProperties().get("filterHiddenDocuments"))) {
            query.addFilter((QueryFilter)this.hiddenDocumentQueryFilterProvider.get());
        }
        query.setWiki(spaceReference.getWikiReference().getName());
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            query.bindValue(entry.getKey(), entry.getValue());
        }
        return ((Long)query.execute().get(0)).intValue();
    }

    public String getParent(String nodeId) {
        EntityReference spaceReference = this.resolve(nodeId);
        if (spaceReference != null && spaceReference.getType() == EntityType.SPACE) {
            return this.serialize(spaceReference.getParent());
        }
        return null;
    }
}

