/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.tree.internal.parentchild;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.index.tree.internal.parentchild.DocumentQueryHelper;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;

@Component
@Named(value="document/parentChild")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DocumentTreeNode
extends org.xwiki.index.tree.internal.nestedpages.DocumentTreeNode {
    @Inject
    @Named(value="compact")
    private EntityReferenceSerializer<String> compactEntityReferenceSerializer;
    @Inject
    private DocumentQueryHelper documentQueryHelper;
    @Inject
    private Provider<XWikiContext> xcontextProvider;

    @Override
    protected List<DocumentReference> getChildDocuments(DocumentReference documentReference, int offset, int limit) throws QueryException {
        return this.documentQueryHelper.resolve(this.getChildrenQuery(new DocumentReference((EntityReference)documentReference)), offset, limit, (EntityReference)documentReference);
    }

    private Query getChildrenQuery(DocumentReference parentReference) throws QueryException {
        ArrayList<String> constraints = new ArrayList<String>();
        constraints.add("doc.translation = 0");
        constraints.add("(doc.parent in (:absoluteRef, :localRef) or (doc.space = :space and doc.parent = :relativeRef))");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("space", this.localEntityReferenceSerializer.serialize(parentReference.getParent(), new Object[0]));
        parameters.put("absoluteRef", this.defaultEntityReferenceSerializer.serialize((EntityReference)parentReference, new Object[0]));
        parameters.put("localRef", this.localEntityReferenceSerializer.serialize((EntityReference)parentReference, new Object[0]));
        parameters.put("relativeRef", this.compactEntityReferenceSerializer.serialize((EntityReference)parentReference, new Object[]{parentReference.getParent()}));
        Query query = this.documentQueryHelper.getQuery(constraints, parameters, this.getProperties());
        query.setWiki(parentReference.getWikiReference().getName());
        return query;
    }

    @Override
    protected int getChildDocumentsCount(DocumentReference documentReference) throws QueryException {
        Query query = this.getChildrenQuery(documentReference);
        query.addFilter(this.countQueryFilter);
        return ((Long)query.execute().get(0)).intValue();
    }

    @Override
    protected EntityReference getParent(DocumentReference documentReference) throws Exception {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument document = xcontext.getWiki().getDocument(documentReference, xcontext);
        DocumentReference parentReference = document.getParentReference();
        if (parentReference == null || !parentReference.getWikiReference().equals((Object)documentReference.getWikiReference())) {
            return documentReference.getWikiReference();
        }
        return parentReference;
    }
}

