/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.index.tree.internal.nestedpages;

import javax.inject.Named;

import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.tree.AbstractTreeNode;

/**
 * The translation tree node.
 * 
 * @version $Id: b5a5f0b8d0705ea126f35e7deaf8db423542fa60 $
 * @since 8.3M2
 * @since 7.4.5
 */
@Component
@Named("translation")
@InstantiationStrategy(ComponentInstantiationStrategy.PER_LOOKUP)
public class TranslationTreeNode extends AbstractTreeNode
{
    @Override
    public String getParent(String nodeId)
    {
        if (StringUtils.startsWith(nodeId, "translation:")) {
            String reference = StringUtils.substringBeforeLast(nodeId.substring(12), "/");
            return "translations:" + reference;
        }
        return null;
    }
}
