/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.instance.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.store.XWikiHibernateBaseStore;
import com.xpn.xwiki.store.XWikiStoreInterface;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.instance.InstanceId;
import org.xwiki.instance.InstanceIdManager;

@Component
@Singleton
public class DefaultInstanceIdManager
implements InstanceIdManager {
    @Inject
    @Named(value="hibernate")
    private XWikiStoreInterface hibernateStore;
    @Inject
    private Execution execution;
    @Inject
    private Logger logger;
    private InstanceId instanceId;

    @Override
    public InstanceId getInstanceId() {
        return this.instanceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeInstanceId() {
        if (this.instanceId == null) {
            XWikiContext context = this.getXWikiContext();
            XWikiHibernateBaseStore store = (XWikiHibernateBaseStore)this.hibernateStore;
            String originalDatabase = context.getDatabase();
            context.setDatabase(context.getMainXWiki());
            try {
                InstanceId id = (InstanceId)store.failSafeExecuteRead(context, (XWikiHibernateBaseStore.HibernateCallback)new XWikiHibernateBaseStore.HibernateCallback<InstanceId>(){

                    public InstanceId doInHibernate(Session session) throws HibernateException {
                        return (InstanceId)session.createCriteria(InstanceId.class).uniqueResult();
                    }
                });
                if (id == null) {
                    final InstanceId newId = new InstanceId(UUID.randomUUID().toString());
                    try {
                        store.executeWrite(context, (XWikiHibernateBaseStore.HibernateCallback)new XWikiHibernateBaseStore.HibernateCallback<Object>(){

                            public Object doInHibernate(Session session) throws HibernateException {
                                session.createQuery("delete from " + InstanceId.class.getName()).executeUpdate();
                                session.save((Object)newId);
                                return null;
                            }
                        });
                    }
                    catch (XWikiException e) {
                        this.logger.warn("Failed to save Instance id to database. Reason: [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                    }
                    id = newId;
                }
                this.instanceId = id;
            }
            finally {
                context.setDatabase(originalDatabase);
            }
        }
    }

    private XWikiContext getXWikiContext() {
        ExecutionContext context = this.execution.getContext();
        return (XWikiContext)context.getProperty("xwikicontext");
    }
}

