/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ircbot.internal;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUtils;
import org.apache.commons.collections.buffer.CircularFifoBuffer;
import org.xwiki.component.annotation.Component;
import org.xwiki.ircbot.BrokenLinkEventListenerConfiguration;
import org.xwiki.ircbot.IRCBot;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.rendering.transformation.linkchecker.InvalidURLEvent;
import org.xwiki.rendering.transformation.linkchecker.LinkState;

@Component
@Named(value="ircbrokenlink")
@Singleton
public class BrokenLinkEventListener
implements EventListener {
    private static final String URL = "url";
    @Inject
    private IRCBot bot;
    @Inject
    private BrokenLinkEventListenerConfiguration configuration;
    private Buffer lastBrokenLinks = BufferUtils.synchronizedBuffer((Buffer)new CircularFifoBuffer(4));

    public String getName() {
        return "ircbrokenlink";
    }

    public List<Event> getEvents() {
        return Arrays.asList(new InvalidURLEvent());
    }

    public void onEvent(Event event, Object source, Object data) {
        if (this.bot.isConnected() && this.configuration.isActive()) {
            Map brokenLinkData = (Map)source;
            String linkURL = (String)brokenLinkData.get(URL);
            this.removeDuplicateLinkData(linkURL);
            this.lastBrokenLinks.add((Object)brokenLinkData);
            String linkSource = (String)brokenLinkData.get("source");
            LinkState linkState = (LinkState)brokenLinkData.get("state");
            int responseCode = linkState.getResponseCode();
            String message = String.format("Invalid link found %s on page %s (code = %s)", linkURL, linkSource, responseCode);
            this.bot.sendMessage(this.bot.getChannelsNames().iterator().next(), message);
        }
    }

    private void removeDuplicateLinkData(String linkURL) {
        Iterator it = this.lastBrokenLinks.iterator();
        Map duplicateBrokenLinkData = null;
        while (it.hasNext()) {
            Map savedLinkData = (Map)it.next();
            String savedLinkURL = (String)savedLinkData.get(URL);
            if (!linkURL.equals(savedLinkURL)) continue;
            duplicateBrokenLinkData = savedLinkData;
            break;
        }
        if (duplicateBrokenLinkData != null) {
            this.lastBrokenLinks.remove(duplicateBrokenLinkData);
        }
    }

    public Buffer getLastBrokenLinks() {
        return BufferUtils.unmodifiableBuffer((Buffer)this.lastBrokenLinks);
    }
}

