/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ircbot.internal;

import com.xpn.xwiki.doc.XWikiDocument;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.ircbot.DocumentModifiedEventListenerConfiguration;
import org.xwiki.ircbot.IRCBot;
import org.xwiki.ircbot.IRCBotException;
import org.xwiki.ircbot.wiki.WikiIRCModel;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;

@Component
@Named(value="ircdocumentmodified")
@Singleton
public class DocumentModifiedEventListener
implements EventListener {
    @Inject
    private IRCBot bot;
    @Inject
    private DocumentModifiedEventListenerConfiguration configuration;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private Logger logger;
    @Inject
    private WikiIRCModel ircModel;

    public List<Event> getEvents() {
        return Arrays.asList(new DocumentUpdatedEvent(), new DocumentDeletedEvent(), new DocumentCreatedEvent());
    }

    public String getName() {
        return "ircdocumentmodified";
    }

    public void onEvent(Event event, Object source, Object data) {
        if (this.bot.isConnected() && source instanceof XWikiDocument) {
            XWikiDocument document = (XWikiDocument)source;
            DocumentReference reference = document.getDocumentReference();
            String referenceAsString = (String)this.serializer.serialize((EntityReference)reference, new Object[0]);
            boolean shouldSendNotification = true;
            try {
                for (Pattern pattern : this.configuration.getExclusionPatterns()) {
                    if (!pattern.matcher(referenceAsString).matches()) continue;
                    shouldSendNotification = false;
                    break;
                }
                if (shouldSendNotification) {
                    String message = String.format("%s was modified by %s %s - %s", referenceAsString, this.getNotificationAuthor(event, document), this.getNotificationComment(event, document), this.getNotificationURL(event, document));
                    this.bot.sendMessage(this.bot.getChannelsNames().iterator().next(), message);
                }
            }
            catch (IRCBotException e) {
                this.logger.error("Failed to send IRC notification for document [{}]", this.serializer.serialize((EntityReference)reference, new Object[0]), (Object)e);
            }
        }
    }

    private String getNotificationAuthor(Event event, XWikiDocument source) throws IRCBotException {
        DocumentReference authorReference = event instanceof DocumentDeletedEvent ? this.ircModel.getXWikiContext().getUserReference() : source.getAuthorReference();
        return (String)this.serializer.serialize((EntityReference)authorReference, new Object[0]);
    }

    private String getNotificationComment(Event event, XWikiDocument source) {
        String comment;
        if (event instanceof DocumentDeletedEvent) {
            comment = "(deleted)";
        } else if (event instanceof DocumentCreatedEvent) {
            comment = "(created)";
            if (!StringUtils.isEmpty((CharSequence)source.getComment())) {
                comment = comment + " " + source.getComment();
            }
        } else {
            comment = source.getComment();
        }
        return comment;
    }

    private String getNotificationURL(Event event, XWikiDocument source) throws IRCBotException {
        String queryString = null;
        if (!(event instanceof DocumentCreatedEvent) && !(event instanceof DocumentDeletedEvent)) {
            queryString = String.format("viewer=changes&amp;rev2=%s", source.getVersion());
        }
        return source.getExternalURL("view", queryString, this.ircModel.getXWikiContext());
    }
}

