/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ircbot.internal.wiki;

import com.xpn.xwiki.XWikiContext;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.pircbotx.PircBotX;
import org.pircbotx.hooks.Event;
import org.pircbotx.hooks.ListenerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.ircbot.IRCBotException;
import org.xwiki.ircbot.IRCBotListener;
import org.xwiki.ircbot.internal.wiki.WikiBotListenerData;
import org.xwiki.ircbot.wiki.WikiIRCBotConstants;
import org.xwiki.ircbot.wiki.WikiIRCModel;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.Transformation;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.transformation.TransformationException;

public class WikiIRCBotListener<T extends PircBotX>
extends ListenerAdapter<T>
implements IRCBotListener<T>,
WikiIRCBotConstants {
    public static final String LISTENER_XWIKICONTEXT_PROPERTY = "irclistener";
    private static final Logger LOGGER = LoggerFactory.getLogger(WikiIRCBotListener.class);
    private WikiBotListenerData listenerData;
    private Map<String, XDOM> events;
    private Syntax syntax;
    private Transformation macroTransformation;
    private BlockRenderer plainTextBlockRenderer;
    private WikiIRCModel ircModel;
    private DocumentReference executingUserReference;
    private Map<String, Object> initializationBindings = new HashMap<String, Object>();

    public WikiIRCBotListener(WikiBotListenerData listenerData, Map<String, XDOM> events, Syntax syntax, Transformation macroTransformation, BlockRenderer plainTextBlockRenderer, WikiIRCModel ircModel, DocumentReference executingUserReference) {
        this.listenerData = listenerData;
        this.events = events;
        this.syntax = syntax;
        this.macroTransformation = macroTransformation;
        this.plainTextBlockRenderer = plainTextBlockRenderer;
        this.ircModel = ircModel;
        this.executingUserReference = executingUserReference;
    }

    @Override
    public String getName() {
        return this.listenerData.getName();
    }

    @Override
    public String getDescription() {
        return this.listenerData.getDescription();
    }

    public void initialize() {
        XDOM xdom = this.events.get("onRegistration");
        if (xdom != null) {
            try {
                this.renderContent(xdom);
                XWikiContext context = this.ircModel.getXWikiContext();
                Map bindings = (Map)context.get((Object)LISTENER_XWIKICONTEXT_PROPERTY);
                if (bindings != null) {
                    this.initializationBindings.putAll(bindings);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failed to initialize Wiki Bot Listener [{}]", (Object)this.getName(), (Object)e);
            }
        }
    }

    public void onEvent(final Event event) {
        String eventName = "on" + StringUtils.removeEnd((String)event.getClass().getSimpleName(), (String)"Event");
        final XDOM xdom = this.events.get(eventName);
        if (xdom != null) {
            try {
                this.addBindings(event);
                this.ircModel.executeAsUser(this.executingUserReference, this.listenerData.getReference(), new WikiIRCModel.Executor(){

                    @Override
                    public void execute() throws Exception {
                        String result = WikiIRCBotListener.this.renderContent(xdom);
                        if (!StringUtils.isEmpty((CharSequence)result)) {
                            event.respond(result);
                        }
                    }
                });
            }
            catch (Exception e) {
                LOGGER.warn(String.format("Failed to execute IRC Bot Listener script [%s]", eventName), (Throwable)e);
            }
        }
    }

    private String renderContent(XDOM xdom) throws TransformationException {
        XDOM temporaryXDOM = xdom.clone();
        TransformationContext txContext = new TransformationContext(temporaryXDOM, this.syntax);
        this.macroTransformation.transform((Block)temporaryXDOM, txContext);
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        this.plainTextBlockRenderer.render((Block)temporaryXDOM, (WikiPrinter)printer);
        return StringUtils.trim((String)printer.toString());
    }

    private void addBindings(Event event) throws IRCBotException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.putAll(this.initializationBindings);
        this.bindVariable("getMessage", event, params, "message");
        this.bindVariable("getUser", event, params, "user", "source");
        this.bindVariable("getChannel", event, params, "channel");
        this.bindVariable("getReason", event, params, "reason");
        this.bindVariable("getRecipient", event, params, "recipient");
        this.bindVariable("getOldNick", event, params, "oldNick");
        this.bindVariable("getNewNick", event, params, "newNick");
        params.put("bot", event.getBot());
        XWikiContext context = this.ircModel.getXWikiContext();
        context.put((Object)LISTENER_XWIKICONTEXT_PROPERTY, params);
    }

    private void bindVariable(String methodName, Event event, Map<String, Object> params, String ... variableNames) {
        try {
            Method getMessageMethod = event.getClass().getMethod(methodName, new Class[0]);
            Object value = getMessageMethod.invoke((Object)event, new Object[0]);
            for (String variableName : variableNames) {
                params.put(variableName, value);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

