/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ircbot.internal;

import javax.inject.Inject;
import javax.inject.Named;
import org.pircbotx.hooks.ListenerAdapter;
import org.pircbotx.hooks.events.DisconnectEvent;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.ircbot.IRCBotListener;
import org.xwiki.ircbot.internal.ExtendedPircBotX;

@Component
@Named(value="autoreconnect")
public class AutoReconnectListener<T extends ExtendedPircBotX>
extends ListenerAdapter<T>
implements IRCBotListener<T> {
    @Inject
    private Logger logger;

    @Override
    public String getDescription() {
        return "Automatically reconnect the Bot to the channels it's been disconnected from";
    }

    @Override
    public String getName() {
        return "AutoReconnect";
    }

    public void onDisconnect(DisconnectEvent<T> event) throws Exception {
        ExtendedPircBotX bot = (ExtendedPircBotX)event.getBot();
        if (!bot.shouldStop()) {
            this.logger.debug("IRC Bot has been disconnected");
            while (!bot.isConnected()) {
                try {
                    bot.reconnect();
                }
                catch (Exception e) {
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException ie) {}
                }
            }
        }
    }
}

