/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ircbot.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.ircbot.DocumentModifiedEventListenerConfiguration;
import org.xwiki.ircbot.IRCBot;
import org.xwiki.ircbot.IRCBotException;
import org.xwiki.ircbot.wiki.WikiIRCModel;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;

@Component
@Named(value="ircdocumentmodified")
@Singleton
public class DocumentModifiedEventListener
implements EventListener {
    @Inject
    private IRCBot bot;
    @Inject
    private DocumentModifiedEventListenerConfiguration configuration;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private Logger logger;
    @Inject
    private WikiIRCModel ircModel;
    @Inject
    private Execution execution;

    public List<Event> getEvents() {
        return Arrays.asList(new DocumentUpdatedEvent(), new DocumentDeletedEvent(), new DocumentCreatedEvent());
    }

    public String getName() {
        return "ircdocumentmodified";
    }

    public void onEvent(Event event, Object source, Object data) {
        if (this.bot.isConnected() && source instanceof XWikiDocument && data instanceof XWikiContext) {
            XWikiDocument document = (XWikiDocument)source;
            XWikiContext xcontext = (XWikiContext)data;
            DocumentReference reference = document.getDocumentReference();
            String referenceAsString = (String)this.serializer.serialize((EntityReference)reference, new Object[0]);
            try {
                if (this.shouldSendNotification(referenceAsString)) {
                    String message = String.format("%s was %s by %s%s - %s", referenceAsString, this.getNotificationAction(event), this.getNotificationAuthor(xcontext), this.getNotificationComment(document), this.getNotificationURL(event, document, xcontext));
                    Iterator<String> channelNameItator = this.bot.getChannelsNames().iterator();
                    if (channelNameItator.hasNext()) {
                        this.bot.sendMessage(channelNameItator.next(), message);
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("Failed to send IRC notification for document [{}], event [{}] and data [{}]", new Object[]{reference, event, data, e});
            }
        }
    }

    private boolean shouldSendNotification(String referenceAsString) throws IRCBotException {
        boolean shouldSendNotification = true;
        ExecutionContext ec = this.execution.getContext();
        Object importCounterObject = ec.getProperty("ircxarcounter");
        if (importCounterObject != null) {
            long newCounter = (Long)importCounterObject;
            ec.setProperty("ircxarcounter", (Object)(++newCounter));
            shouldSendNotification = false;
        } else {
            for (Pattern pattern : this.configuration.getExclusionPatterns()) {
                if (!pattern.matcher(referenceAsString).matches()) continue;
                shouldSendNotification = false;
                break;
            }
        }
        return shouldSendNotification;
    }

    private String getNotificationAuthor(XWikiContext xcontext) throws IRCBotException {
        DocumentReference userReference = xcontext.getUserReference();
        String user = userReference != null ? (String)this.serializer.serialize((EntityReference)userReference, new Object[0]) : "Guest";
        return user;
    }

    private String getNotificationAction(Event event) {
        String action = event instanceof DocumentDeletedEvent ? "deleted" : (event instanceof DocumentCreatedEvent ? "created" : "modified");
        return action;
    }

    private String getNotificationComment(XWikiDocument source) {
        String comment = !StringUtils.isEmpty((CharSequence)source.getComment()) ? String.format(" (%s)", source.getComment()) : "";
        return comment;
    }

    private String getNotificationURL(Event event, XWikiDocument source, XWikiContext xcontext) throws IRCBotException {
        String url;
        String queryString = null;
        try {
            if (!(event instanceof DocumentCreatedEvent) && !(event instanceof DocumentDeletedEvent)) {
                queryString = String.format("viewer=changes&amp;rev2=%s", source.getVersion());
            }
            url = source.getExternalURL("view", queryString, xcontext);
        }
        catch (Exception e) {
            url = String.format("Failed to compute URL for document [%s] and query string [%s]", source.getDocumentReference(), queryString);
            this.logger.warn(url, (Throwable)e);
        }
        return url;
    }
}

