/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ircbot.internal;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.pircbotx.PircBotX;
import org.pircbotx.hooks.ListenerAdapter;
import org.pircbotx.hooks.events.MessageEvent;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.ircbot.IRCBotListener;

@Component
@Named(value="help")
@Singleton
public class HelpIRCBotListener<T extends PircBotX>
extends ListenerAdapter<T>
implements IRCBotListener<T> {
    private static final String COMMAND = "!help";
    @Inject
    private Logger logger;
    @Inject
    @Named(value="wiki")
    private ComponentManager componentManager;

    @Override
    public String getName() {
        return "Help";
    }

    @Override
    public String getDescription() {
        return String.format("%s: List all commands available", COMMAND);
    }

    public void onMessage(MessageEvent<T> event) throws Exception {
        if (event.getMessage().startsWith(COMMAND)) {
            event.respond("Available Bot listeners:");
            for (IRCBotListener listener : this.getIRCBotListeners()) {
                event.respond(" - " + listener.getDescription());
            }
        }
    }

    private List<IRCBotListener> getIRCBotListeners() {
        List result;
        try {
            result = this.componentManager.getInstanceList(IRCBotListener.class);
        }
        catch (ComponentLookupException e) {
            this.logger.warn("Failed to look up IRC Bot Listeners", (Throwable)e);
            result = Collections.emptyList();
        }
        return result;
    }
}

