/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ircbot.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.util.XWikiStubContextProvider;
import com.xpn.xwiki.web.XWikiURLFactory;
import java.util.concurrent.ThreadFactory;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.context.ExecutionContextException;
import org.xwiki.context.ExecutionContextManager;

public class XWikiContextualizedThreadFactory
implements ThreadFactory {
    private Execution execution;
    private ExecutionContextManager executionContextManager;
    private XWikiStubContextProvider stubContextProvider;
    private String currentWiki;

    public XWikiContextualizedThreadFactory(Execution execution, ExecutionContextManager executionContextManager, XWikiStubContextProvider stubContextProvider, String currentWiki) {
        this.execution = execution;
        this.executionContextManager = executionContextManager;
        this.stubContextProvider = stubContextProvider;
        this.currentWiki = currentWiki;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        return new XWikiContextualizedThread(runnable);
    }

    private class XWikiContextualizedThread
    extends Thread {
        public XWikiContextualizedThread(Runnable runnable) {
            super(runnable);
        }

        @Override
        public void run() {
            ExecutionContext context = XWikiContextualizedThreadFactory.this.execution.getContext();
            if (context == null) {
                context = new ExecutionContext();
                try {
                    XWikiContextualizedThreadFactory.this.executionContextManager.initialize(context);
                }
                catch (ExecutionContextException e) {
                    throw new RuntimeException("Failed to initialize IRC Bot's execution context", e);
                }
                XWikiContext xwikiContext = XWikiContextualizedThreadFactory.this.stubContextProvider.createStubContext();
                context.setProperty("xwikicontext", (Object)xwikiContext);
                XWikiURLFactory urlf = xwikiContext.getWiki().getURLFactoryService().createURLFactory(0, xwikiContext);
                xwikiContext.setURLFactory(urlf);
                xwikiContext.setDatabase(XWikiContextualizedThreadFactory.this.currentWiki);
                XWikiContextualizedThreadFactory.this.execution.pushContext(context);
            }
            super.run();
        }
    }
}

