/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ircbot.internal.wiki;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.ircbot.IRCBotException;
import org.xwiki.ircbot.internal.wiki.WikiBotListenerData;
import org.xwiki.ircbot.internal.wiki.WikiIRCBotListener;
import org.xwiki.ircbot.wiki.WikiIRCBotConstants;
import org.xwiki.ircbot.wiki.WikiIRCBotListenerFactory;
import org.xwiki.ircbot.wiki.WikiIRCModel;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.transformation.Transformation;

@Component
@Singleton
public class DefaultWikiIRCBotListenerFactory
implements WikiIRCBotListenerFactory,
WikiIRCBotConstants {
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Logger logger;
    @Inject
    @Named(value="macro")
    private Transformation macroTransformation;
    @Inject
    @Named(value="plain/1.0")
    private BlockRenderer plainTextBlockRenderer;
    @Inject
    @Named(value="compactwiki")
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private WikiIRCModel ircModel;

    @Override
    public WikiIRCBotListener createWikiListener(DocumentReference documentReference) throws IRCBotException {
        XWikiDocument doc = this.ircModel.getDocument(documentReference);
        BaseObject listenerDefinition = doc.getXObject(WIKI_BOT_LISTENER_CLASS);
        String name = listenerDefinition.getStringValue("name");
        String description = listenerDefinition.getStringValue("description");
        HashMap<String, XDOM> events = new HashMap<String, XDOM>();
        List listenerEvents = doc.getXObjects(WIKI_BOT_LISTENER_EVENT_CLASS);
        if (null != listenerEvents) {
            for (BaseObject listenerEvent : listenerEvents) {
                XDOM eventScriptXDOM;
                if (null == listenerEvent) continue;
                String eventName = listenerEvent.getStringValue("event");
                String eventScript = listenerEvent.getStringValue("script");
                try {
                    Parser parser = (Parser)this.componentManager.getInstance(Parser.class, doc.getSyntax().toIdString());
                    eventScriptXDOM = parser.parse((Reader)new StringReader(eventScript));
                }
                catch (ComponentLookupException e) {
                    throw new IRCBotException(String.format("Could not find a parser for the event content [%s]", eventName), e);
                }
                catch (ParseException e) {
                    throw new IRCBotException(String.format("Error while parsing event script [%s]", eventName), e);
                }
                events.put(eventName, eventScriptXDOM);
            }
        }
        WikiBotListenerData botListenerData = new WikiBotListenerData(documentReference, (String)this.entityReferenceSerializer.serialize((EntityReference)doc.getDocumentReference(), new Object[0]), name, description);
        WikiIRCBotListener listener = new WikiIRCBotListener(botListenerData, events, doc.getSyntax(), this.macroTransformation, this.plainTextBlockRenderer, this.ircModel, this.ircModel.getXWikiContext().getUserReference());
        listener.initialize();
        return listener;
    }

    @Override
    public boolean containsWikiListener(DocumentReference documentReference) {
        boolean result;
        try {
            XWikiDocument doc = this.ircModel.getDocument(documentReference);
            BaseObject listenerDefinition = doc.getXObject(WIKI_BOT_LISTENER_CLASS);
            result = null != listenerDefinition;
            result = result && listenerDefinition.getIntValue("inactive") != 1;
            List listenerEventDefinitions = doc.getXObjects(WIKI_BOT_LISTENER_EVENT_CLASS);
            result = result && listenerEventDefinitions != null && listenerEventDefinitions.size() > 0;
        }
        catch (Exception ex) {
            result = false;
        }
        return result;
    }
}

