/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ircbot.internal.wiki;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.pircbotx.hooks.Listener;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.DefaultComponentDescriptor;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.manager.ComponentRepositoryException;
import org.xwiki.ircbot.IRCBot;
import org.xwiki.ircbot.IRCBotException;
import org.xwiki.ircbot.IRCBotListener;
import org.xwiki.ircbot.internal.BotListenerData;
import org.xwiki.ircbot.internal.wiki.WikiIRCBotListener;
import org.xwiki.ircbot.wiki.WikiIRCBotConstants;
import org.xwiki.ircbot.wiki.WikiIRCBotListenerFactory;
import org.xwiki.ircbot.wiki.WikiIRCBotListenerManager;
import org.xwiki.ircbot.wiki.WikiIRCModel;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;

@Component
@Singleton
public class DefaultWikiIRCBotListenerManager
implements WikiIRCBotListenerManager,
WikiIRCBotConstants {
    @Inject
    private WikiIRCBotListenerFactory listenerFactory;
    @Inject
    @Named(value="wiki")
    private ComponentManager componentManager;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> currentReferenceResolver;
    @Inject
    private IRCBot bot;
    @Inject
    @Named(value="compactwiki")
    private EntityReferenceSerializer<String> compactWikiSerializer;
    @Inject
    private WikiIRCModel ircModel;

    @Override
    public void registerWikiBotListener(DocumentReference reference) throws IRCBotException {
        String hint = (String)this.compactWikiSerializer.serialize((EntityReference)reference, new Object[0]);
        if (!this.componentManager.hasComponent(IRCBotListener.class, hint) && this.listenerFactory.containsWikiListener(reference)) {
            WikiIRCBotListener wikiListener = this.listenerFactory.createWikiListener(reference);
            try {
                DefaultComponentDescriptor componentDescriptor = new DefaultComponentDescriptor();
                componentDescriptor.setRoleType(IRCBotListener.class);
                componentDescriptor.setRoleHint(hint);
                this.componentManager.registerComponent((ComponentDescriptor)componentDescriptor, (Object)wikiListener);
            }
            catch (ComponentRepositoryException e) {
                throw new IRCBotException(String.format("Unable to register Wiki IRC Bot Listener in document [%s]", reference), e);
            }
            this.bot.getListenerManager().addListener((Listener)wikiListener);
        }
    }

    @Override
    public void unregisterWikiBotListener(DocumentReference reference) throws IRCBotException {
        String hint = (String)this.compactWikiSerializer.serialize((EntityReference)reference, new Object[0]);
        if (this.componentManager.hasComponent(IRCBotListener.class, hint)) {
            IRCBotListener listener;
            try {
                listener = (IRCBotListener)this.componentManager.getInstance(IRCBotListener.class, hint);
            }
            catch (ComponentLookupException e) {
                throw new IRCBotException("Failed to unregister Wiki IRC Bot Listener", e);
            }
            this.componentManager.unregisterComponent(IRCBotListener.class, hint);
            this.bot.getListenerManager().removeListener((Listener)listener);
        }
    }

    @Override
    public void registerWikiBotListeners() throws IRCBotException {
        for (BotListenerData data : this.ircModel.getWikiBotListenerData()) {
            DocumentReference reference = this.currentReferenceResolver.resolve((Object)data.getId(), new Object[0]);
            this.registerWikiBotListener(reference);
        }
    }

    @Override
    public void unregisterWikiBotListeners() throws IRCBotException {
        for (BotListenerData data : this.ircModel.getWikiBotListenerData()) {
            DocumentReference reference = this.currentReferenceResolver.resolve((Object)data.getId(), new Object[0]);
            this.unregisterWikiBotListener(reference);
        }
    }
}

