/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.jira;

import com.atlassian.jira.rest.client.AuthenticationHandler;
import com.atlassian.jira.rest.client.JiraRestClient;
import com.atlassian.jira.rest.client.NullProgressMonitor;
import com.atlassian.jira.rest.client.ProgressMonitor;
import com.atlassian.jira.rest.client.auth.AnonymousAuthenticationHandler;
import com.atlassian.jira.rest.client.auth.BasicHttpAuthenticationHandler;
import com.atlassian.jira.rest.client.internal.jersey.JerseyJiraRestClientFactory;
import java.net.URI;
import java.net.URISyntaxException;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.script.service.ScriptService;

@Component
@Named(value="jira")
public class JiraScriptService
implements ScriptService {
    @Inject
    private Logger logger;

    public JiraRestClient getJiraRestClient(String jiraURL, String username, String password) {
        return this.getJiraRestClient(jiraURL, (AuthenticationHandler)new BasicHttpAuthenticationHandler(username, password));
    }

    public JiraRestClient getJiraRestClient(String jiraURL) {
        return this.getJiraRestClient(jiraURL, (AuthenticationHandler)new AnonymousAuthenticationHandler());
    }

    public ProgressMonitor getNullProgressMonitor() {
        return new NullProgressMonitor();
    }

    private JiraRestClient getJiraRestClient(String jiraURL, AuthenticationHandler authenticationHandler) {
        JiraRestClient restClient;
        try {
            JerseyJiraRestClientFactory factory = new JerseyJiraRestClientFactory();
            URI jiraServerUri = new URI(jiraURL);
            restClient = factory.create(jiraServerUri, authenticationHandler);
        }
        catch (URISyntaxException e) {
            this.logger.warn("Invalid JIRA URL [{}]", (Object)jiraURL);
            restClient = null;
        }
        return restClient;
    }
}

