/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.handler.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.xwiki.container.Container;
import org.xwiki.container.Response;
import org.xwiki.job.handler.internal.JobResourceReferenceHandler;
import org.xwiki.resource.ResourceReferenceHandlerException;
import org.xwiki.template.Template;
import org.xwiki.template.TemplateManager;

public abstract class AbstractTemplateJobResourceReferenceHandler
implements JobResourceReferenceHandler {
    @Inject
    protected TemplateManager templates;
    @Inject
    protected Container container;

    protected boolean tryTemplates(String contentType, String ... templateNames) throws ResourceReferenceHandlerException {
        for (String templateName : templateNames) {
            if (!this.tryTemplate(contentType, templateName)) continue;
            return true;
        }
        return false;
    }

    protected boolean tryTemplate(String defaultContentType, String templateName) throws ResourceReferenceHandlerException {
        Template template = this.templates.getTemplate("job/" + templateName);
        if (template == null) {
            return false;
        }
        Response response = this.container.getResponse();
        try {
            if (defaultContentType != null) {
                response.setContentType(defaultContentType);
            }
            StringWriter writer = new StringWriter();
            this.templates.render(template, (Writer)writer);
            this.sendContent(((Object)writer).toString());
        }
        catch (Exception e) {
            throw new ResourceReferenceHandlerException("Failed to execute template [" + templateName + "]", (Throwable)e);
        }
        return true;
    }

    protected void sendContent(String content) throws ResourceReferenceHandlerException {
        Response response = this.container.getResponse();
        try (OutputStream stream = response.getOutputStream();){
            IOUtils.write((String)content, (OutputStream)stream, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new ResourceReferenceHandlerException("Failed to send content", (Throwable)e);
        }
    }
}

