/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal.colortheme;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.web.XWikiRequest;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component(roles={CurrentColorThemeGetter.class})
@Singleton
public class CurrentColorThemeGetter {
    private static final String COLOR_THEME_FIELD = "colorTheme";
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private AuthorizationManager authorizationManager;

    public String getCurrentColorTheme(String fallbackValue) {
        return this.getCurrentColorTheme(true, fallbackValue);
    }

    public String getCurrentColorTheme(boolean checkRights, String fallbackValue) {
        String wikiId = this.wikiDescriptorManager.getCurrentWikiId();
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        XWiki xwiki = context.getWiki();
        XWikiRequest request = context.getRequest();
        String colorTheme = request.getParameter(COLOR_THEME_FIELD);
        if (StringUtils.isEmpty((CharSequence)colorTheme)) {
            colorTheme = xwiki.getUserPreference(COLOR_THEME_FIELD, context);
        }
        DocumentReference colorThemeReference = this.documentReferenceResolver.resolve((Object)colorTheme, new Object[]{new WikiReference(wikiId)});
        colorTheme = (String)this.entityReferenceSerializer.serialize((EntityReference)colorThemeReference, new Object[0]);
        if (!xwiki.exists(colorThemeReference, context) || checkRights && !this.authorizationManager.hasAccess(Right.VIEW, context.getUserReference(), (EntityReference)colorThemeReference)) {
            colorTheme = fallbackValue;
        }
        return colorTheme;
    }
}

