/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal.colortheme.converter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.lesscss.compiler.LESSCompiler;
import org.xwiki.lesscss.compiler.LESSCompilerException;
import org.xwiki.lesscss.internal.cache.CachedCompilerInterface;
import org.xwiki.lesscss.internal.colortheme.ColorTheme;
import org.xwiki.lesscss.resources.LESSResourceReference;

@Component(roles={CachedLESSColorThemeConverter.class})
@Singleton
public class CachedLESSColorThemeConverter
implements CachedCompilerInterface<ColorTheme> {
    @Inject
    private LESSCompiler lessCompiler;
    private final Pattern pattern = Pattern.compile("\\.colortheme-(\\w+)[\\s$]*\\{(\\w+):(#*\\w+)(;)*\\}");

    @Override
    public ColorTheme compute(LESSResourceReference lessResourceReference, boolean includeSkinStyle, boolean useVelocity, boolean useLESS, String skin) throws LESSCompilerException {
        return this.getColorThemeFromCSS(this.lessCompiler.compile(lessResourceReference, false, useVelocity, skin, false));
    }

    private ColorTheme getColorThemeFromCSS(String css) {
        ColorTheme results = new ColorTheme();
        String cssWithoutComments = css.replaceAll("/\\*[\\u0000-\\uffff]*?\\*/", "");
        Matcher m = this.pattern.matcher(cssWithoutComments);
        while (m.find()) {
            String variable = m.group(1);
            String value = m.group(3);
            results.put((Object)variable, (Object)value);
        }
        return results;
    }
}

