/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal.compiler.less4j;

import com.github.sommeri.less4j.LessSource;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.lesscss.internal.compiler.less4j.AbstractLESSSource;
import org.xwiki.skin.Skin;
import org.xwiki.template.Template;
import org.xwiki.template.TemplateContent;
import org.xwiki.template.TemplateManager;

public class TemplateLESSSource
extends AbstractLESSSource {
    private static final String FILE_SEPARATOR = "/";
    private String templateName;

    public TemplateLESSSource(TemplateManager templateManager, Skin skin, String templateName) {
        super(templateManager, skin, TemplateLESSSource.getParentFolder(templateName));
        this.templateName = templateName;
    }

    private static String getParentFolder(String templateName) {
        return StringUtils.substringBeforeLast((String)templateName, (String)FILE_SEPARATOR);
    }

    public String getContent() throws LessSource.FileNotFound, LessSource.CannotReadFile {
        try {
            String mainSkinTemplate = "less/style.less.vm";
            if (mainSkinTemplate.equals(this.templateName)) {
                return this.templateManager.renderFromSkin(this.templateName, this.skin);
            }
            Template template = this.templateManager.getTemplate(this.templateName, this.skin);
            TemplateContent templateContent = template.getContent();
            return templateContent.getContent();
        }
        catch (Exception e) {
            throw new LessSource.CannotReadFile();
        }
    }

    public byte[] getBytes() throws LessSource.FileNotFound, LessSource.CannotReadFile {
        return this.getContent().getBytes();
    }

    public String getName() {
        return this.templateName;
    }
}

