/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal.resources;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.lesscss.internal.resources.LESSObjectPropertyResourceReference;
import org.xwiki.lesscss.internal.resources.LESSSkinFileResourceReference;
import org.xwiki.lesscss.resources.LESSResourceReference;
import org.xwiki.lesscss.resources.LESSResourceReferenceFactory;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.ObjectPropertyReference;
import org.xwiki.skin.SkinManager;
import org.xwiki.template.TemplateManager;

@Component
@Singleton
public class DefaultLESSResourceReferenceFactory
implements LESSResourceReferenceFactory {
    @Inject
    private TemplateManager templateManager;
    @Inject
    private SkinManager skinManager;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private DocumentAccessBridge bridge;

    public LESSResourceReference createReferenceForSkinFile(String fileName) {
        return new LESSSkinFileResourceReference(fileName, this.templateManager, this.skinManager);
    }

    public LESSResourceReference createReferenceForXObjectProperty(ObjectPropertyReference objectPropertyReference) {
        return new LESSObjectPropertyResourceReference(objectPropertyReference, this.entityReferenceSerializer, this.bridge);
    }
}

