/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal.colortheme.converter;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.lesscss.compiler.LESSCompilerException;
import org.xwiki.lesscss.internal.cache.AbstractCachedCompiler;
import org.xwiki.lesscss.internal.cache.ColorThemeCache;
import org.xwiki.lesscss.internal.colortheme.ColorTheme;
import org.xwiki.lesscss.internal.colortheme.LESSColorThemeConverter;
import org.xwiki.lesscss.internal.colortheme.converter.CachedLESSColorThemeConverter;
import org.xwiki.lesscss.resources.LESSResourceReferenceFactory;

@Component
@Singleton
public class DefaultLESSColorThemeConverter
extends AbstractCachedCompiler<ColorTheme>
implements LESSColorThemeConverter,
Initializable {
    private static final ColorTheme EMPTY_COLOR_THEME = new ColorTheme();
    @Inject
    private ColorThemeCache cache;
    @Inject
    private CachedLESSColorThemeConverter cachedLESSColorThemeConverter;
    @Inject
    private LESSResourceReferenceFactory lessResourceReferenceFactory;

    public void initialize() throws InitializationException {
        ((AbstractCachedCompiler)this).cache = this.cache;
        this.compiler = this.cachedLESSColorThemeConverter;
    }

    public ColorTheme getColorThemeFromSkinFile(String fileName, boolean force) throws LESSCompilerException {
        return (ColorTheme)super.getResult(this.lessResourceReferenceFactory.createReferenceForSkinFile(fileName), false, true, force);
    }

    public ColorTheme getColorThemeFromSkinFile(String fileName, String skin, boolean force) throws LESSCompilerException {
        return (ColorTheme)super.getResult(this.lessResourceReferenceFactory.createReferenceForSkinFile(fileName), false, true, skin, force);
    }

    @Override
    protected ColorTheme cloneResult(ColorTheme toClone) {
        return new ColorTheme(toClone);
    }

    @Override
    protected ColorTheme exceptionAsResult(LESSCompilerException exception) {
        return EMPTY_COLOR_THEME;
    }
}

