/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal;

import com.xpn.xwiki.doc.XWikiDocument;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.lesscss.ColorThemeCache;
import org.xwiki.lesscss.LESSSkinFileCache;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;

@Component
@Named(value="lessColorTheme")
@Singleton
public class ColorThemeListener
implements EventListener {
    private static final LocalDocumentReference COLOR_THEME_CLASS = new LocalDocumentReference("ColorThemes", "ColorThemeClass");
    private static final LocalDocumentReference FLAMINGO_THEME_CLASS = new LocalDocumentReference("FlamingoThemesCode", "ThemeClass");
    @Inject
    private LESSSkinFileCache lessSkinFileCache;
    @Inject
    private ColorThemeCache colorThemeCache;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;

    public String getName() {
        return "LESS Color Theme Listener";
    }

    public List<Event> getEvents() {
        return Arrays.asList(new DocumentCreatedEvent(), new DocumentUpdatedEvent(), new DocumentDeletedEvent());
    }

    public void onEvent(Event event, Object source, Object data) {
        XWikiDocument document = (XWikiDocument)source;
        List flamingoThemeObjects = document.getXObjects((EntityReference)FLAMINGO_THEME_CLASS);
        if (flamingoThemeObjects != null && !flamingoThemeObjects.isEmpty()) {
            this.clearCacheFromColorTheme(document);
            return;
        }
        List colorThemeObjects = document.getXObjects((EntityReference)COLOR_THEME_CLASS);
        if (colorThemeObjects != null && !colorThemeObjects.isEmpty()) {
            this.clearCacheFromColorTheme(document);
            return;
        }
    }

    private void clearCacheFromColorTheme(XWikiDocument document) {
        String fullName = (String)this.entityReferenceSerializer.serialize((EntityReference)document.getDocumentReference(), new Object[0]);
        this.lessSkinFileCache.clearFromColorTheme(fullName);
        this.colorThemeCache.clearFromColorTheme(fullName);
    }
}

