/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.web.XWikiRequest;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.event.ActionExecutingEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.lesscss.ColorThemeCache;
import org.xwiki.lesscss.LESSSkinFileCache;
import org.xwiki.lesscss.internal.CurrentColorThemeGetter;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;

@Component
@Named(value="lessexport")
@Singleton
public class LESSExportActionListener
implements EventListener {
    @Inject
    private LESSSkinFileCache lessSkinFileCache;
    @Inject
    private ColorThemeCache colorThemeCache;
    @Inject
    private CurrentColorThemeGetter currentColorThemeGetter;

    public String getName() {
        return "lessexport";
    }

    public List<Event> getEvents() {
        return Arrays.asList(new ActionExecutingEvent("export"));
    }

    public void onEvent(Event event, Object source, Object data) {
        XWikiContext xcontext = (XWikiContext)data;
        XWikiRequest request = xcontext.getRequest();
        String format = request.get("format");
        if ("html".equals(format)) {
            String colorTheme = this.currentColorThemeGetter.getCurrentColorTheme("default");
            this.lessSkinFileCache.clearFromColorTheme(colorTheme);
            this.colorThemeCache.clearFromColorTheme(colorTheme);
        }
    }
}

