/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal.colortheme;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.lesscss.cache.ColorThemeCache;
import org.xwiki.lesscss.colortheme.ColorTheme;
import org.xwiki.lesscss.colortheme.LESSColorThemeConverter;
import org.xwiki.lesscss.compiler.LESSCompilerException;
import org.xwiki.lesscss.internal.cache.AbstractCachedCompiler;
import org.xwiki.lesscss.internal.colortheme.CachedLESSColorThemeConverter;
import org.xwiki.lesscss.resources.LESSResourceReference;
import org.xwiki.lesscss.resources.LESSSkinFileResourceReference;

@Component
@Singleton
public class DefaultLESSColorThemeConverter
extends AbstractCachedCompiler<ColorTheme>
implements LESSColorThemeConverter,
Initializable {
    @Inject
    private ColorThemeCache cache;
    @Inject
    private CachedLESSColorThemeConverter cachedLESSColorThemeConverter;

    public void initialize() throws InitializationException {
        ((AbstractCachedCompiler)this).cache = this.cache;
        this.compiler = this.cachedLESSColorThemeConverter;
    }

    public ColorTheme getColorThemeFromSkinFile(String fileName, boolean force) throws LESSCompilerException {
        return (ColorTheme)super.getResult((LESSResourceReference)new LESSSkinFileResourceReference(fileName), false, true, force);
    }

    public ColorTheme getColorThemeFromSkinFile(String fileName, String skin, boolean force) throws LESSCompilerException {
        return (ColorTheme)super.getResult((LESSResourceReference)new LESSSkinFileResourceReference(fileName), false, true, skin, force);
    }

    @Override
    protected ColorTheme cloneResult(ColorTheme toClone) {
        return new ColorTheme(toClone);
    }
}

