/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal.listeners;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseObjectReference;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.lesscss.cache.ColorThemeCache;
import org.xwiki.lesscss.cache.LESSResourcesCache;
import org.xwiki.lesscss.resources.LESSObjectPropertyResourceReference;
import org.xwiki.lesscss.resources.LESSResourceReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.ObjectPropertyReference;
import org.xwiki.model.reference.ObjectReference;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Named(value="lessSSX")
@Singleton
public class SSXListener
implements EventListener {
    @Inject
    private LESSResourcesCache lessResourcesCache;
    @Inject
    private ColorThemeCache colorThemeCache;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;

    public String getName() {
        return "LESS SSX objects listener";
    }

    public List<Event> getEvents() {
        return Arrays.asList(new DocumentCreatedEvent(), new DocumentUpdatedEvent(), new DocumentDeletedEvent());
    }

    public void onEvent(Event event, Object source, Object data) {
        XWikiDocument document = (XWikiDocument)source;
        String currentWiki = this.wikiDescriptorManager.getCurrentWikiId();
        DocumentReference ssxDocRef = new DocumentReference(currentWiki, "XWiki", "StyleSheetExtension");
        List ssxObjects = document.getXObjects(ssxDocRef);
        if (ssxObjects != null && !ssxObjects.isEmpty()) {
            for (BaseObject obj : ssxObjects) {
                if (obj == null || !"LESS".equals(obj.getStringValue("contentType"))) continue;
                LESSObjectPropertyResourceReference lessObjectPropertyResourceReference = new LESSObjectPropertyResourceReference(new ObjectPropertyReference("code", (ObjectReference)new BaseObjectReference(ssxDocRef, Integer.valueOf(obj.getNumber()), document.getDocumentReference())));
                this.lessResourcesCache.clearFromLESSResource((LESSResourceReference)lessObjectPropertyResourceReference);
                this.colorThemeCache.clearFromLESSResource((LESSResourceReference)lessObjectPropertyResourceReference);
            }
        }
    }
}

