/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal.resources;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.lesscss.compiler.LESSCompilerException;
import org.xwiki.lesscss.internal.compiler.SkinDirectoryGetter;
import org.xwiki.lesscss.resources.LESSResourceReader;
import org.xwiki.lesscss.resources.LESSResourceReference;
import org.xwiki.lesscss.resources.LESSSkinFileResourceReference;

@Component
@Named(value="org.xwiki.lesscss.resources.LESSSkinFileResourceReference")
@Singleton
public class LESSSkinFileReader
implements LESSResourceReader {
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private SkinDirectoryGetter skinDirectoryGetter;

    public String getContent(LESSResourceReference lessResourceReference, String skin) throws LESSCompilerException {
        if (!(lessResourceReference instanceof LESSSkinFileResourceReference)) {
            throw new LESSCompilerException("Invalid LESS resource type.");
        }
        LESSSkinFileResourceReference lessSkinFileResourceReference = (LESSSkinFileResourceReference)lessResourceReference;
        return this.getSkinFileContent(this.skinDirectoryGetter.getSkinDirectory(skin) + "/less/", lessSkinFileResourceReference.getFileName());
    }

    private String getSkinFileContent(String directory, String fileName) throws LESSCompilerException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWiki xwiki = xcontext.getWiki();
        String fullFileName = directory + fileName;
        File lessFile = new File(xwiki.getEngineContext().getRealPath(fullFileName));
        if (!lessFile.exists() || !lessFile.isFile()) {
            throw new LESSCompilerException(String.format("The path [%s] is not a file or does not exists.", fullFileName));
        }
        try {
            InputStream is = xwiki.getEngineContext().getResourceAsStream(fullFileName);
            StringWriter content = new StringWriter();
            IOUtils.copy((InputStream)is, (Writer)content);
            return content.toString();
        }
        catch (IOException e) {
            throw new LESSCompilerException(String.format("Error while reading the file [%s].", fullFileName));
        }
    }
}

