/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal.skin;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.lesscss.compiler.LESSCompilerException;
import org.xwiki.lesscss.skin.DocumentSkinReference;
import org.xwiki.lesscss.skin.FSSkinReference;
import org.xwiki.lesscss.skin.SkinReference;
import org.xwiki.lesscss.skin.SkinReferenceFactory;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Singleton
public class DefaultSkinReferenceFactory
implements SkinReferenceFactory {
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;

    public SkinReference createReference(String skinName) throws LESSCompilerException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWiki xwiki = xcontext.getWiki();
        String currentWikiId = this.wikiDescriptorManager.getCurrentWikiId();
        DocumentReference skinDocRef = this.documentReferenceResolver.resolve((Object)skinName, new Object[]{new WikiReference(currentWikiId)});
        if (xwiki.exists(skinDocRef, xcontext)) {
            try {
                XWikiDocument skinDoc = xwiki.getDocument(skinDocRef, xcontext);
                DocumentReference skinClassDocRef = new DocumentReference(skinDocRef.getWikiReference().getName(), "XWiki", "XWikiSkins");
                if (skinDoc.getXObjectSize(skinClassDocRef) > 0) {
                    return new DocumentSkinReference(skinDocRef);
                }
            }
            catch (XWikiException e) {
                throw new LESSCompilerException(String.format("Unable to read document [%s]", skinDocRef), (Exception)((Object)e));
            }
        }
        return new FSSkinReference(skinName);
    }
}

