/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss;

import com.xpn.xwiki.XWikiContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.lesscss.ColorTheme;
import org.xwiki.lesscss.ColorThemeCache;
import org.xwiki.lesscss.LESSColorThemeConverter;
import org.xwiki.lesscss.LESSCompilerException;
import org.xwiki.lesscss.LESSSkinFileCache;
import org.xwiki.lesscss.LESSSkinFileCompiler;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.script.service.ScriptService;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.stability.Unstable;

@Component
@Named(value="lesscss")
@Singleton
@Unstable
public class LessCompilerScriptService
implements ScriptService {
    @Inject
    private LESSSkinFileCompiler lessCompiler;
    @Inject
    private LESSSkinFileCache lessCache;
    @Inject
    private ColorThemeCache colorThemeCache;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private LESSColorThemeConverter lessColorThemeConverter;
    @Inject
    private AuthorizationManager authorizationManager;

    public String compileSkinFile(String fileName) {
        return this.compileSkinFile(fileName, false);
    }

    public String compileSkinFile(String fileName, boolean force) {
        try {
            return this.lessCompiler.compileSkinFile(fileName, force);
        }
        catch (LESSCompilerException e) {
            return e.getMessage();
        }
    }

    public String compileSkinFile(String fileName, String skin) {
        return this.compileSkinFile(fileName, skin, false);
    }

    public String compileSkinFile(String fileName, String skin, boolean force) {
        try {
            return this.lessCompiler.compileSkinFile(fileName, skin, force);
        }
        catch (LESSCompilerException e) {
            return e.getMessage();
        }
    }

    public ColorTheme getColorThemeFromSkinFile(String filename) {
        try {
            return this.lessColorThemeConverter.getColorThemeFromSkinFile(filename, false);
        }
        catch (LESSCompilerException e) {
            return new ColorTheme();
        }
    }

    public ColorTheme getColorThemeFromSkinFile(String filename, String skin) {
        try {
            return this.lessColorThemeConverter.getColorThemeFromSkinFile(filename, skin, false);
        }
        catch (LESSCompilerException e) {
            return new ColorTheme();
        }
    }

    public boolean clearCache() {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        if (!this.authorizationManager.hasAccess(Right.PROGRAM, xcontext.getDoc().getAuthorReference(), (EntityReference)xcontext.getDoc().getDocumentReference())) {
            return false;
        }
        this.lessCache.clear();
        this.colorThemeCache.clear();
        return true;
    }

    public boolean clearCacheFromColorTheme(String colorTheme) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        if (!this.authorizationManager.hasAccess(Right.PROGRAM, xcontext.getDoc().getAuthorReference(), (EntityReference)xcontext.getDoc().getDocumentReference())) {
            return false;
        }
        this.lessCache.clearFromColorTheme(colorTheme);
        this.colorThemeCache.clearFromColorTheme(colorTheme);
        return true;
    }

    public boolean clearCacheFromFileSystemSkin(String skin) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        if (!this.authorizationManager.hasAccess(Right.PROGRAM, xcontext.getDoc().getAuthorReference(), (EntityReference)xcontext.getDoc().getDocumentReference())) {
            return false;
        }
        this.lessCache.clearFromFileSystemSkin(skin);
        this.colorThemeCache.clearFromFileSystemSkin(skin);
        return true;
    }
}

