/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.localization.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.localization.TranslationBundle;
import org.xwiki.localization.TranslationBundleContext;
import org.xwiki.model.EntityType;
import org.xwiki.model.ModelContext;
import org.xwiki.model.reference.EntityReference;

@Component
@Singleton
public class DefaultTranslationBundleContext
implements TranslationBundleContext {
    public static final String CKEY_BUNDLES = "localization.bundles";
    @Inject
    private Execution execution;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private Logger logger;
    @Inject
    private ModelContext modelContext;

    private SortedSet<TranslationBundle> initializeCurrentBundles() {
        TreeSet<TranslationBundle> currentBundles = new TreeSet<TranslationBundle>();
        try {
            ComponentManager componentManager = (ComponentManager)this.componentManagerProvider.get();
            List availableBundles = componentManager.getInstanceList(TranslationBundle.class);
            currentBundles.addAll(availableBundles);
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to lookup Bundle components", (Throwable)e);
        }
        return currentBundles;
    }

    private Map<String, SortedSet<TranslationBundle>> getBundlesInternal() {
        Map bundles;
        ExecutionContext context = this.execution.getContext();
        if (context != null) {
            bundles = (Map)context.getProperty(CKEY_BUNDLES);
            if (bundles == null) {
                bundles = new HashMap();
                context.newProperty(CKEY_BUNDLES).inherited().cloneValue().initial(bundles).declare();
            }
        } else {
            bundles = new HashMap();
        }
        return bundles;
    }

    private SortedSet<TranslationBundle> getCurrentBundlesInternal() {
        String currentWiki = this.getCurrentWiki();
        Map<String, SortedSet<TranslationBundle>> bundlesMap = this.getBundlesInternal();
        SortedSet<TranslationBundle> currentBundles = bundlesMap.get(currentWiki);
        if (currentBundles == null) {
            currentBundles = this.initializeCurrentBundles();
            bundlesMap.put(currentWiki, currentBundles);
        }
        return currentBundles;
    }

    @Override
    public Collection<TranslationBundle> getBundles() {
        return this.getCurrentBundlesInternal();
    }

    @Override
    public void addBundle(TranslationBundle bundle) {
        this.getCurrentBundlesInternal().add(bundle);
    }

    private String getCurrentWiki() {
        EntityReference wikiReference;
        String currentWiki = "";
        EntityReference currentReference = this.modelContext.getCurrentEntityReference();
        if (currentReference != null && (wikiReference = currentReference.extractReference(EntityType.WIKI)) != null) {
            currentWiki = wikiReference.getName();
        }
        return currentWiki;
    }
}

