/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.localization.internal;

import java.util.Collection;
import java.util.PriorityQueue;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.localization.TranslationBundle;
import org.xwiki.localization.TranslationBundleContext;

@Component
@Singleton
public class DefaultTranslationBundleContext
implements TranslationBundleContext {
    private static final String CKEY_BUNDLES = "localization.bundles";
    @Inject
    private Execution execution;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManager;
    @Inject
    private Logger logger;

    private PriorityQueue<TranslationBundle> initializeContextBundle() {
        PriorityQueue<TranslationBundle> bundles;
        try {
            bundles = new PriorityQueue<TranslationBundle>(((ComponentManager)this.componentManager.get()).getInstanceList(TranslationBundle.class));
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to lookup Bundle components", (Throwable)e);
            bundles = new PriorityQueue();
        }
        return bundles;
    }

    private PriorityQueue<TranslationBundle> getBundlesInternal() {
        PriorityQueue<TranslationBundle> bundles;
        ExecutionContext context = this.execution.getContext();
        if (context != null) {
            bundles = (PriorityQueue<TranslationBundle>)context.getProperty(CKEY_BUNDLES);
            if (bundles == null) {
                bundles = this.initializeContextBundle();
                context.setProperty(CKEY_BUNDLES, bundles);
            }
        } else {
            bundles = this.initializeContextBundle();
        }
        return bundles;
    }

    @Override
    public Collection<TranslationBundle> getBundles() {
        return this.getBundlesInternal();
    }

    @Override
    public void addBundle(TranslationBundle bundle) {
        this.getBundlesInternal().add(bundle);
    }
}

