/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.localization.internal;

import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.localization.TranslationBundle;
import org.xwiki.localization.TranslationBundleContext;

@Component
@Singleton
public class DefaultTranslationBundleContext
implements TranslationBundleContext {
    public static final String CKEY_BUNDLES = "localization.bundles";
    @Inject
    private Execution execution;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManager;
    @Inject
    private Logger logger;

    private SortedSet<TranslationBundle> initializeContextBundle() {
        TreeSet<TranslationBundle> bundles;
        try {
            bundles = new TreeSet<TranslationBundle>(((ComponentManager)this.componentManager.get()).getInstanceList(TranslationBundle.class));
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to lookup Bundle components", (Throwable)e);
            bundles = new TreeSet();
        }
        return bundles;
    }

    private SortedSet<TranslationBundle> getBundlesInternal() {
        SortedSet<TranslationBundle> bundles;
        ExecutionContext context = this.execution.getContext();
        if (context != null) {
            bundles = (SortedSet<TranslationBundle>)context.getProperty(CKEY_BUNDLES);
            if (bundles == null) {
                bundles = this.initializeContextBundle();
                context.newProperty(CKEY_BUNDLES).inherited().cloneValue().initial(bundles).declare();
            }
        } else {
            bundles = this.initializeContextBundle();
        }
        return bundles;
    }

    @Override
    public Collection<TranslationBundle> getBundles() {
        return this.getBundlesInternal();
    }

    @Override
    public void addBundle(TranslationBundle bundle) {
        this.getBundlesInternal().add(bundle);
    }
}

