/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.localization.script;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.environment.Environment;
import org.xwiki.localization.LocaleUtils;
import org.xwiki.localization.LocalizationContext;
import org.xwiki.localization.LocalizationManager;
import org.xwiki.localization.Translation;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.script.service.ScriptService;
import org.xwiki.stability.Unstable;
import org.xwiki.text.StringUtils;

@Component
@Named(value="localization")
@Singleton
public class LocalizationScriptService
implements ScriptService {
    @Inject
    private LocalizationManager localization;
    @Inject
    private LocalizationContext localizationContext;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManager;
    @Inject
    private Environment environment;
    @Inject
    private Logger logger;

    public Translation get(String key) {
        return this.get(key, this.localizationContext.getCurrentLocale());
    }

    public Translation get(String key, Locale locale) {
        return this.localization.getTranslation(key, locale);
    }

    public boolean use(String bundleType, String bundleId) {
        try {
            this.localization.use(bundleType, bundleId);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public Locale getCurrentLocale() {
        return this.localizationContext.getCurrentLocale();
    }

    public Locale toLocale(String str) {
        try {
            return LocaleUtils.toLocale((String)str);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String render(String key) {
        return this.render(key, (Collection)null);
    }

    public String render(String key, Locale locale) {
        return this.render(key, (Collection)null, locale);
    }

    public String render(String key, Collection<?> parameters) {
        return this.render(key, Syntax.PLAIN_1_0, parameters);
    }

    public String render(String key, Collection<?> parameters, Locale locale) {
        return this.render(key, Syntax.PLAIN_1_0, parameters);
    }

    public String render(String key, Syntax syntax) {
        return this.render(key, syntax, (Collection)null);
    }

    public String render(String key, Syntax syntax, Locale locale) {
        return this.render(key, syntax, null, locale);
    }

    public String render(String key, Syntax syntax, Collection<?> parameters) {
        return this.render(key, syntax, parameters, this.localizationContext.getCurrentLocale());
    }

    public String render(String key, Syntax syntax, Collection<?> parameters, Locale locale) {
        String result;
        Translation translation = this.localization.getTranslation(key, locale);
        if (translation != null) {
            Block block = parameters != null ? translation.render(locale, parameters.toArray()) : translation.render(locale, new Object[0]);
            try {
                BlockRenderer renderer = (BlockRenderer)((ComponentManager)this.componentManager.get()).getInstance(BlockRenderer.class, syntax.toIdString());
                DefaultWikiPrinter wikiPrinter = new DefaultWikiPrinter();
                renderer.render(block, (WikiPrinter)wikiPrinter);
                result = wikiPrinter.toString();
            }
            catch (ComponentLookupException e) {
                result = null;
            }
        } else {
            result = key;
        }
        return result;
    }

    @Unstable
    public Set<Locale> getAvailableLocales() {
        HashSet<Locale> locales = new HashSet<Locale>();
        locales.addAll(Arrays.asList(Locale.getAvailableLocales()));
        try (InputStream resource = this.environment.getResourceAsStream("/WEB-INF/xwiki-locales.txt");){
            LineIterator iterator = IOUtils.lineIterator((InputStream)resource, (Charset)StandardCharsets.US_ASCII);
            while (iterator.hasNext()) {
                String line = iterator.nextLine();
                if (!StringUtils.isNotBlank((CharSequence)line)) continue;
                locales.add(new Locale(line));
            }
            iterator.close();
        }
        catch (Exception e) {
            this.logger.warn("Exception while looking for XWiki Locales.", (Throwable)e);
        }
        return locales;
    }
}

