/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.localization.jar.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.collections.EnumerationUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.localization.Translation;
import org.xwiki.localization.TranslationBundle;
import org.xwiki.localization.TranslationBundleContext;
import org.xwiki.localization.internal.AbstractCachedTranslationBundle;
import org.xwiki.localization.internal.DefaultLocalizedTranslationBundle;
import org.xwiki.localization.internal.DefaultTranslation;
import org.xwiki.localization.internal.LocalizedTranslationBundle;
import org.xwiki.localization.message.TranslationMessage;
import org.xwiki.localization.message.TranslationMessageParser;

@Component
@Named(value="rootclassloader")
public class RootClassLoaderTranslationBundle
extends AbstractCachedTranslationBundle {
    @Inject
    @Named(value="messagetool/1.0")
    private TranslationMessageParser parser;
    @Inject
    private TranslationBundleContext bundleContext;

    protected LocalizedTranslationBundle createBundle(Locale locale) {
        Properties properties = this.getResourceProperties(locale);
        if (properties == null) {
            return null;
        }
        DefaultLocalizedTranslationBundle localeBundle = new DefaultLocalizedTranslationBundle((TranslationBundle)this, locale);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            String key = (String)entry.getKey();
            String message = (String)entry.getValue();
            TranslationMessage translationMessage = this.parser.parse(message);
            localeBundle.addTranslation((Translation)new DefaultTranslation(this.bundleContext, (LocalizedTranslationBundle)localeBundle, key, translationMessage));
        }
        return localeBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getResourceProperties(Locale locale) {
        Enumeration<URL> urls;
        String resourceName = "ApplicationResources";
        if (!locale.equals(Locale.ROOT)) {
            resourceName = resourceName + "_" + locale;
        }
        resourceName = resourceName + ".properties";
        try {
            urls = ((Object)((Object)this)).getClass().getClassLoader().getResources(resourceName);
        }
        catch (IOException e) {
            this.logger.error("Failed to get resource URLs from class loader for name [{}]", (Object)resourceName, (Object)e);
            return null;
        }
        if (!urls.hasMoreElements()) {
            return null;
        }
        List urlList = EnumerationUtils.toList(urls);
        Properties properties = new Properties();
        ListIterator it = urlList.listIterator(urlList.size());
        while (it.hasPrevious()) {
            URL url = (URL)it.previous();
            try {
                InputStream componentListStream = url.openStream();
                try {
                    properties.load(componentListStream);
                }
                finally {
                    componentListStream.close();
                }
            }
            catch (IOException e) {
                this.logger.error("Failed to parse resource [{}] as translation budle", (Object)url, (Object)e);
            }
        }
        return properties;
    }
}

