/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.localization.legacy.internal.xwikipreferences;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.localization.Translation;
import org.xwiki.localization.internal.AbstractTranslationBundle;
import org.xwiki.localization.legacy.internal.xwikipreferences.XWikiPreferencesWikiTranslationBundle;
import org.xwiki.localization.message.TranslationMessageParser;
import org.xwiki.localization.wiki.internal.DefaultDocumentTranslationBundle;
import org.xwiki.model.EntityType;
import org.xwiki.model.ModelContext;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;

@Component
@Named(value="XWikiPreferences")
@Singleton
public class XWikiPreferencesTranslationBundle
extends AbstractTranslationBundle
implements Initializable {
    protected static final String ID = "XWikiPreferences";
    @Inject
    private ModelContext modelContext;
    @Inject
    private CacheManager cacheManager;
    @Inject
    private ComponentManager componentManager;
    @Inject
    @Named(value="messagetool/1.0")
    private TranslationMessageParser translationMessageParser;
    @Inject
    @Named(value="uid")
    private EntityReferenceSerializer<String> uidSerializer;
    private Map<String, XWikiPreferencesWikiTranslationBundle> wikiBundlesCache = new ConcurrentHashMap<String, XWikiPreferencesWikiTranslationBundle>();
    private Cache<DefaultDocumentTranslationBundle> documentBundlesCache;

    public XWikiPreferencesTranslationBundle() {
        super(ID, 300);
    }

    public void initialize() throws InitializationException {
        CacheConfiguration cacheConfiguration = new CacheConfiguration("localization." + this.getId());
        try {
            this.documentBundlesCache = this.cacheManager.createNewCache(cacheConfiguration);
        }
        catch (CacheException e) {
            this.logger.error("Failed to create cache [{}]", (Object)cacheConfiguration.getConfigurationId(), (Object)e);
        }
    }

    public Translation getTranslation(String key, Locale locale) {
        return this.getBundle().getTranslation(key, locale);
    }

    private XWikiPreferencesWikiTranslationBundle getBundle() {
        String currentWiki = this.modelContext.getCurrentEntityReference().extractReference(EntityType.WIKI).getName();
        return this.getBundle(currentWiki);
    }

    private XWikiPreferencesWikiTranslationBundle getBundle(String wiki) {
        XWikiPreferencesWikiTranslationBundle bundle = this.wikiBundlesCache.get(wiki);
        if (bundle == null) {
            try {
                bundle = this.createWikiBundle(wiki);
                this.wikiBundlesCache.put(wiki, bundle);
            }
            catch (ComponentLookupException e) {
                this.logger.error("Failed to create preferences bundle for wiki [{}]", (Object)wiki, (Object)e);
            }
        }
        return bundle;
    }

    private XWikiPreferencesWikiTranslationBundle createWikiBundle(String wiki) throws ComponentLookupException {
        return new XWikiPreferencesWikiTranslationBundle(wiki, this, this.componentManager);
    }

    protected DefaultDocumentTranslationBundle getDocumentTranslationBundle(DocumentReference document) {
        String uid = (String)this.uidSerializer.serialize((EntityReference)document, new Object[0]);
        DefaultDocumentTranslationBundle documentBundle = (DefaultDocumentTranslationBundle)this.documentBundlesCache.get(uid);
        if (documentBundle == null) {
            try {
                documentBundle = new DefaultDocumentTranslationBundle(document, this.componentManager, this.translationMessageParser);
                this.documentBundlesCache.set(uid, (Object)documentBundle);
            }
            catch (ComponentLookupException e) {
                this.logger.error("Failed to create document bundle for document [{}]", (Object)document, (Object)e);
            }
        }
        return documentBundle;
    }
}

