/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.localization.wiki.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.StringProperty;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.EnumUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.bridge.event.WikiReadyEvent;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.descriptor.DefaultComponentDescriptor;
import org.xwiki.component.internal.multi.ComponentManagerManager;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.manager.ComponentRepositoryException;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.localization.TranslationBundle;
import org.xwiki.localization.TranslationBundleDoesNotExistsException;
import org.xwiki.localization.TranslationBundleFactory;
import org.xwiki.localization.message.TranslationMessageParser;
import org.xwiki.localization.wiki.internal.ComponentDocumentTranslationBundle;
import org.xwiki.localization.wiki.internal.OnDemandDocumentTranslationBundle;
import org.xwiki.localization.wiki.internal.TranslationDocumentModel;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.query.Query;
import org.xwiki.query.QueryManager;
import org.xwiki.security.authorization.AccessDeniedException;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Named(value="document")
@Singleton
public class DocumentTranslationBundleFactory
implements TranslationBundleFactory,
Initializable,
Disposable {
    public static final String ID = "document";
    public static final String ID_PREFIX = "document:";
    private static final List<Event> EVENTS = Arrays.asList(new DocumentUpdatedEvent(), new DocumentDeletedEvent(), new DocumentCreatedEvent());
    private static final List<Event> WIKIEVENTS = Arrays.asList(new WikiReadyEvent());
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    @Named(value="uid")
    private EntityReferenceSerializer<String> uidSerializer;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> currentResolver;
    @Inject
    private CacheManager cacheManager;
    @Inject
    private ObservationManager observation;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    @Named(value="messagetool/1.0")
    private TranslationMessageParser translationParser;
    @Inject
    private ComponentManagerManager cmManager;
    @Inject
    private WikiDescriptorManager wikiManager;
    @Inject
    private Logger logger;
    @Inject
    private QueryManager queryManager;
    @Inject
    private AuthorizationManager authorizationManager;
    private Cache<TranslationBundle> onDemandBundleCache;
    private final EventListener listener = new EventListener(){

        public void onEvent(Event event, Object arg1, Object arg2) {
            DocumentTranslationBundleFactory.this.translationDocumentUpdated((XWikiDocument)arg1);
        }

        public String getName() {
            return "localization.bundle.document";
        }

        public List<Event> getEvents() {
            return EVENTS;
        }
    };
    private final EventListener wikilistener = new EventListener(){

        public void onEvent(Event event, Object arg1, Object arg2) {
            DocumentTranslationBundleFactory.this.loadTranslations(((WikiReadyEvent)event).getWikiId());
        }

        public String getName() {
            return "localization.wikiready";
        }

        public List<Event> getEvents() {
            return WIKIEVENTS;
        }
    };

    public void initialize() throws InitializationException {
        CacheConfiguration cacheConfiguration = new CacheConfiguration("localization.bundle.document");
        try {
            this.onDemandBundleCache = this.cacheManager.createNewCache(cacheConfiguration);
        }
        catch (CacheException e) {
            this.logger.error("Failed to create cache [{}]", (Object)cacheConfiguration.getConfigurationId(), (Object)e);
        }
        this.loadTranslations(this.wikiManager.getMainWikiId());
        this.observation.addListener(this.listener);
        this.observation.addListener(this.wikilistener);
    }

    private void loadTranslations(String wiki) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        WikiReference wikiReference = new WikiReference(wiki);
        try {
            Query query = this.queryManager.createQuery(String.format("select distinct doc.fullName from Document doc, doc.object(%s) as translation", "XWiki.TranslationDocumentClass"), "xwql");
            query.setWiki(wiki);
            List documents = query.execute();
            for (String documentName : documents) {
                DocumentReference reference = this.currentResolver.resolve((Object)documentName, new Object[]{wikiReference});
                XWikiDocument document = xcontext.getWiki().getDocument(reference, xcontext);
                try {
                    this.registerTranslationBundle(document);
                }
                catch (Exception e) {
                    this.logger.error("Failed to register translation bundle from document [{}]", (Object)document.getDocumentReference(), (Object)e);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to load existing translations", (Throwable)e);
        }
    }

    public TranslationBundle getBundle(String bundleId) throws TranslationBundleDoesNotExistsException {
        String roleHint = ID_PREFIX + bundleId;
        if (((ComponentManager)this.componentManagerProvider.get()).hasComponent(TranslationBundle.class, roleHint)) {
            try {
                return (TranslationBundle)((ComponentManager)this.componentManagerProvider.get()).getInstance(TranslationBundle.class, roleHint);
            }
            catch (ComponentLookupException e) {
                this.logger.debug("Failed to lookup component [{}] with hint [{}].", new Object[]{TranslationBundle.class, bundleId, e});
            }
        }
        return this.getOnDemandDocumentBundle(this.currentResolver.resolve((Object)bundleId, new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TranslationBundle getOnDemandDocumentBundle(DocumentReference documentReference) throws TranslationBundleDoesNotExistsException {
        String uid = (String)this.uidSerializer.serialize((EntityReference)documentReference, new Object[0]);
        Object bundle = (TranslationBundle)this.onDemandBundleCache.get(uid);
        if (bundle == null) {
            Cache<TranslationBundle> cache = this.onDemandBundleCache;
            synchronized (cache) {
                bundle = (TranslationBundle)this.onDemandBundleCache.get(uid);
                if (bundle == null) {
                    bundle = this.createOnDemandDocumentBundle(documentReference, uid);
                    this.onDemandBundleCache.set(uid, bundle);
                }
            }
        }
        return bundle;
    }

    private OnDemandDocumentTranslationBundle createOnDemandDocumentBundle(DocumentReference documentReference, String uid) throws TranslationBundleDoesNotExistsException {
        OnDemandDocumentTranslationBundle documentBundle;
        XWikiDocument document;
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        try {
            document = context.getWiki().getDocument(documentReference, context);
        }
        catch (XWikiException e) {
            throw new TranslationBundleDoesNotExistsException("Failed to get translation document", (Throwable)e);
        }
        if (document.isNew()) {
            throw new TranslationBundleDoesNotExistsException(String.format("Document [%s] does not exists", documentReference));
        }
        try {
            documentBundle = new OnDemandDocumentTranslationBundle(ID_PREFIX, document.getDocumentReference(), (ComponentManager)this.componentManagerProvider.get(), this.translationParser, this, uid);
        }
        catch (ComponentLookupException e) {
            throw new TranslationBundleDoesNotExistsException("Failed to create document bundle", (Throwable)e);
        }
        return documentBundle;
    }

    private ComponentDocumentTranslationBundle createComponentDocumentBundle(XWikiDocument document, ComponentDescriptor<TranslationBundle> descriptor) throws TranslationBundleDoesNotExistsException {
        ComponentDocumentTranslationBundle documentBundle;
        try {
            documentBundle = new ComponentDocumentTranslationBundle(ID_PREFIX, document.getDocumentReference(), (ComponentManager)this.componentManagerProvider.get(), this.translationParser, descriptor);
        }
        catch (ComponentLookupException e) {
            throw new TranslationBundleDoesNotExistsException("Failed to create document bundle", (Throwable)e);
        }
        return documentBundle;
    }

    void clear(String uid) {
        this.onDemandBundleCache.remove(uid);
    }

    private void translationDocumentUpdated(XWikiDocument document) {
        if (!document.getOriginalDocument().isNew()) {
            this.unregisterTranslationBundle(document.getOriginalDocument());
        }
        if (!document.isNew()) {
            try {
                this.registerTranslationBundle(document);
            }
            catch (Exception e) {
                this.logger.error("Failed to register translation bundle from document [{}]", (Object)document.getDocumentReference(), (Object)e);
            }
        }
    }

    private TranslationDocumentModel.Scope getScope(XWikiDocument document) {
        BaseObject obj = document.getXObject(TranslationDocumentModel.TRANSLATIONCLASS_REFERENCE);
        if (obj != null) {
            return this.getScope(obj);
        }
        return null;
    }

    private TranslationDocumentModel.Scope getScope(BaseObject obj) {
        StringProperty scopeProperty;
        if (obj != null && (scopeProperty = (StringProperty)obj.getField("scope")) != null) {
            String scopeString = scopeProperty.getValue();
            return (TranslationDocumentModel.Scope)EnumUtils.getEnum(TranslationDocumentModel.Scope.class, (String)scopeString.toUpperCase());
        }
        return null;
    }

    private void unregisterTranslationBundle(XWikiDocument document) {
        TranslationDocumentModel.Scope scope = this.getScope(document);
        if (scope != null && scope != TranslationDocumentModel.Scope.ON_DEMAND) {
            ComponentDescriptor<TranslationBundle> descriptor = this.createComponentDescriptor(document.getDocumentReference());
            this.getComponentManager(document, scope, true).unregisterComponent(descriptor);
        }
        this.onDemandBundleCache.remove((String)this.uidSerializer.serialize((EntityReference)document.getDocumentReference(), new Object[0]));
    }

    private void registerTranslationBundle(XWikiDocument document) throws TranslationBundleDoesNotExistsException, ComponentRepositoryException, AccessDeniedException {
        TranslationDocumentModel.Scope scope = this.getScope(document);
        if (scope != null && scope != TranslationDocumentModel.Scope.ON_DEMAND) {
            this.checkRegistrationAuthorization(document, scope);
            ComponentDescriptor<TranslationBundle> descriptor = this.createComponentDescriptor(document.getDocumentReference());
            ComponentDocumentTranslationBundle bundle = this.createComponentDocumentBundle(document, descriptor);
            this.getComponentManager(document, scope, true).registerComponent(descriptor, (Object)bundle);
        }
    }

    private void checkRegistrationAuthorization(XWikiDocument document, TranslationDocumentModel.Scope scope) throws AccessDeniedException {
        switch (scope) {
            case GLOBAL: {
                this.authorizationManager.checkAccess(Right.PROGRAM, document.getAuthorReference(), null);
                break;
            }
            case WIKI: {
                this.authorizationManager.checkAccess(Right.ADMIN, document.getAuthorReference(), (EntityReference)document.getDocumentReference().getWikiReference());
                break;
            }
        }
    }

    private ComponentDescriptor<TranslationBundle> createComponentDescriptor(DocumentReference documentReference) {
        DefaultComponentDescriptor descriptor = new DefaultComponentDescriptor();
        descriptor.setImplementation(ComponentDocumentTranslationBundle.class);
        descriptor.setInstantiationStrategy(ComponentInstantiationStrategy.SINGLETON);
        descriptor.setRoleHint(ID_PREFIX + (String)this.serializer.serialize((EntityReference)documentReference, new Object[0]));
        descriptor.setRoleType(TranslationBundle.class);
        return descriptor;
    }

    private ComponentManager getComponentManager(XWikiDocument document, TranslationDocumentModel.Scope scope, boolean create) {
        String hint;
        switch (scope) {
            case WIKI: {
                hint = "wiki:" + document.getDocumentReference().getWikiReference().getName();
                break;
            }
            case USER: {
                hint = "user:" + (String)this.serializer.serialize((EntityReference)document.getAuthorReference(), new Object[0]);
                break;
            }
            default: {
                hint = null;
            }
        }
        return this.cmManager.getComponentManager(hint, create);
    }

    public void dispose() throws ComponentLifecycleException {
        this.observation.removeListener(this.listener.getName());
        this.observation.removeListener(this.wikilistener.getName());
    }
}

