/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.localization.messagetool.internal;

import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.xwiki.localization.TranslationBundle;
import org.xwiki.localization.message.TranslationMessage;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.CompositeBlock;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.util.ParserUtils;

public class MessageFormatTranslationMessage
implements TranslationMessage {
    private static final ParserUtils PARSERUTILS = new ParserUtils();
    private String message;
    private Parser plainParser;

    public MessageFormatTranslationMessage(String message, Parser plainParser) {
        this.message = message;
        this.plainParser = plainParser;
    }

    public Block render(Locale locale, Collection<TranslationBundle> bundles, Object ... parameters) {
        Object block;
        String result = parameters.length > 0 ? MessageFormat.format(this.message, parameters) : this.message;
        try {
            List blocks = this.plainParser.parse((Reader)new StringReader(result)).getChildren();
            PARSERUTILS.removeTopLevelParagraph(blocks);
            block = blocks.size() == 0 ? new CompositeBlock() : (blocks.size() == 1 ? (Block)blocks.get(0) : new CompositeBlock(blocks));
        }
        catch (ParseException e) {
            block = null;
        }
        return block;
    }

    public String getRawSource() {
        return this.message;
    }
}

